/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal;

import com.android.annotations.NonNull;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.utils.SparseArray;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import java.util.Map;

public class FakeAndroidTarget
implements IAndroidTarget {
    private final String mSdkLocation;
    private final SparseArray<String> mPaths = new SparseArray();
    private final List<String> mBootClasspath = Lists.newArrayListWithExpectedSize((int)2);
    private final int mApiLevel;

    public FakeAndroidTarget(String sdkLocation, String target) {
        this.mSdkLocation = sdkLocation;
        this.mApiLevel = this.getApiLevel(target);
        if ("unstubbed".equals(target)) {
            this.mBootClasspath.add(this.mSdkLocation + "/out/target/common/obj/JAVA_LIBRARIES/framework_intermediates/classes.jar");
            this.mBootClasspath.add(this.mSdkLocation + "/out/target/common/obj/JAVA_LIBRARIES/core_intermediates/classes.jar");
            this.mPaths.put(1, (Object)(this.mSdkLocation + "/prebuilts/sdk/current/" + "android.jar"));
            this.mPaths.put(2, (Object)(this.mSdkLocation + "/prebuilts/sdk/renderscript/" + "framework.aidl"));
        } else {
            String apiPrebuilts = "current".equals(target) ? this.mSdkLocation + "/prebuilts/sdk/current/" : this.mSdkLocation + "/prebuilts/sdk/" + Integer.toString(this.mApiLevel) + "/";
            this.mBootClasspath.add(apiPrebuilts + "android.jar");
            this.mPaths.put(1, (Object)(apiPrebuilts + "android.jar"));
            this.mPaths.put(2, (Object)(apiPrebuilts + "framework.aidl"));
        }
    }

    private int getApiLevel(String target) {
        if (target.startsWith("android-")) {
            return Integer.parseInt(target.substring("android-".length()));
        }
        return 99;
    }

    public String getPath(int pathId) {
        return (String)this.mPaths.get(pathId);
    }

    public File getFile(int pathId) {
        return new File(this.getPath(pathId));
    }

    public BuildToolInfo getBuildToolInfo() {
        return null;
    }

    @NonNull
    public List<String> getBootClasspath() {
        return this.mBootClasspath;
    }

    public String getLocation() {
        return this.mSdkLocation;
    }

    public String getVendor() {
        return "android";
    }

    public String getName() {
        return "android";
    }

    public String getFullName() {
        return "android";
    }

    public String getClasspathName() {
        return "android";
    }

    public String getShortClasspathName() {
        return "android";
    }

    public String getDescription() {
        return "android";
    }

    public AndroidVersion getVersion() {
        return new AndroidVersion(this.mApiLevel, null);
    }

    public String getVersionName() {
        return "Android API level " + this.mApiLevel;
    }

    public int getRevision() {
        return 1;
    }

    public boolean isPlatform() {
        return true;
    }

    public IAndroidTarget getParent() {
        return null;
    }

    public boolean hasRenderingLibrary() {
        return false;
    }

    public File[] getSkins() {
        return new File[0];
    }

    public File getDefaultSkin() {
        return null;
    }

    public IAndroidTarget.IOptionalLibrary[] getOptionalLibraries() {
        return new IAndroidTarget.IOptionalLibrary[0];
    }

    public String[] getPlatformLibraries() {
        return new String[0];
    }

    public String getProperty(String name) {
        return null;
    }

    public Integer getProperty(String name, Integer defaultValue) {
        return null;
    }

    public Boolean getProperty(String name, Boolean defaultValue) {
        return null;
    }

    public Map<String, String> getProperties() {
        return null;
    }

    public int getUsbVendorId() {
        return 0;
    }

    public ISystemImage[] getSystemImages() {
        return new ISystemImage[0];
    }

    public ISystemImage getSystemImage(IdDisplay tag, String abiType) {
        return null;
    }

    public boolean canRunOn(IAndroidTarget target) {
        return false;
    }

    public String hashString() {
        return "android-" + this.mApiLevel;
    }

    public int compareTo(IAndroidTarget iAndroidTarget) {
        FakeAndroidTarget that = (FakeAndroidTarget)iAndroidTarget;
        return this.mSdkLocation.compareTo(that.mSdkLocation);
    }
}

