/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.build;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.SplitOutput;
import com.android.resources.Density;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SplitOutputMatcher {
    @Nullable
    public static SplitOutput computeBestOutput(@NonNull List<? extends SplitOutput> outputs, int density, @NonNull List<String> abis) {
        Density densityEnum = Density.getEnum((int)density);
        String densityValue = densityEnum == null ? null : densityEnum.getResourceValue();
        ArrayList matches = Lists.newArrayListWithExpectedSize((int)outputs.size());
        for (SplitOutput splitOutput : outputs) {
            String densityFilter = splitOutput.getDensityFilter();
            String abiFilter = splitOutput.getAbiFilter();
            if (densityFilter != null && !densityFilter.equals(densityValue) || abiFilter != null && !abis.contains(abiFilter)) continue;
            matches.add(splitOutput);
        }
        if (matches.isEmpty()) {
            return null;
        }
        return Collections.max(matches, new Comparator<SplitOutput>(){

            @Override
            public int compare(SplitOutput splitOutput, SplitOutput splitOutput2) {
                return splitOutput.getVersionCode() - splitOutput2.getVersionCode();
            }
        });
    }
}

