/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.res2.DataItem;
import com.android.ide.common.res2.DataSet;
import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.res2.ValueResourceParser2;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.utils.ILogger;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceSet
extends DataSet<ResourceItem, ResourceFile> {
    public ResourceSet(String name) {
        super(name);
    }

    @Override
    protected DataSet<ResourceItem, ResourceFile> createSet(String name) {
        return new ResourceSet(name);
    }

    @Override
    protected ResourceFile createFileAndItems(File sourceFolder, File file, ILogger logger) throws MergingException {
        FolderData folderData = ResourceSet.getFolderData(file.getParentFile());
        if (folderData == null) {
            return null;
        }
        return ResourceSet.createResourceFile(file, folderData, logger);
    }

    @Override
    protected ResourceFile createFileAndItems(@NonNull File file, @NonNull Node fileNode) {
        Attr qualifierAttr = (Attr)fileNode.getAttributes().getNamedItem("qualifiers");
        String qualifier = qualifierAttr != null ? qualifierAttr.getValue() : "";
        Attr typeAttr = (Attr)fileNode.getAttributes().getNamedItem("type");
        if (typeAttr == null) {
            ArrayList resourceList = Lists.newArrayList();
            NodeList resNodes = fileNode.getChildNodes();
            int nnn = resNodes.getLength();
            for (int iii = 0; iii < nnn; ++iii) {
                ResourceItem r;
                Node resNode = resNodes.item(iii);
                if (resNode.getNodeType() != 1 || (r = ValueResourceParser2.getResource(resNode, file)) == null) continue;
                resourceList.add(r);
                if (r.getType() != ResourceType.DECLARE_STYLEABLE) continue;
                try {
                    ValueResourceParser2.addStyleableItems(resNode, resourceList, null, file);
                    continue;
                }
                catch (MergingException ignored) {
                    assert (false) : file + ": " + ignored.getMessage();
                    continue;
                }
            }
            return new ResourceFile(file, resourceList, qualifier);
        }
        ResourceType type = ResourceType.getEnum((String)typeAttr.getValue());
        if (type == null) {
            return null;
        }
        Attr nameAttr = (Attr)fileNode.getAttributes().getNamedItem("name");
        if (nameAttr == null) {
            return null;
        }
        ResourceItem item = new ResourceItem(nameAttr.getValue(), type, null);
        return new ResourceFile(file, item, qualifier);
    }

    @Override
    protected void readSourceFolder(File sourceFolder, ILogger logger) throws MergingException {
        File[] folders = sourceFolder.listFiles();
        if (folders != null) {
            for (File folder : folders) {
                FolderData folderData;
                if (!folder.isDirectory() || ResourceSet.isIgnored(folder) || (folderData = ResourceSet.getFolderData(folder)) == null) continue;
                this.parseFolder(sourceFolder, folder, folderData, logger);
            }
        }
    }

    @Override
    protected boolean isValidSourceFile(@NonNull File sourceFolder, @NonNull File file) {
        if (!super.isValidSourceFile(sourceFolder, file)) {
            return false;
        }
        File resFolder = file.getParentFile();
        return resFolder.getParentFile().equals(sourceFolder) && !ResourceSet.isIgnored(resFolder) && ResourceFolderType.getFolderType((String)resFolder.getName()) != null;
    }

    @Override
    protected boolean handleChangedFile(@NonNull File sourceFolder, @NonNull File changedFile) throws MergingException {
        FolderData folderData = ResourceSet.getFolderData(changedFile.getParentFile());
        if (folderData == null) {
            return true;
        }
        ResourceFile resourceFile = (ResourceFile)this.getDataFile(changedFile);
        if (resourceFile == null) {
            String message = String.format("In DataSet '%s', no data file for changedFile '%s'. This is an internal error in the incremental builds code; to work around it, try doing a full clean build.", this.getConfigName(), changedFile.getAbsolutePath());
            throw new MergingException(message).setFile(changedFile);
        }
        if (folderData.type != null) {
            ((ResourceItem)resourceFile.getItem()).setTouched();
        } else {
            ValueResourceParser2 parser = new ValueResourceParser2(changedFile);
            List<ResourceItem> parsedItems = parser.parseFile();
            HashMap oldItems = Maps.newHashMap(resourceFile.getItemMap());
            HashMap newItems = Maps.newHashMap();
            ResourceFile fakeResourceFile = new ResourceFile(changedFile, parsedItems, resourceFile.getQualifiers());
            for (ResourceItem resourceItem : parsedItems) {
                String newKey = resourceItem.getKey();
                ResourceItem oldItem = (ResourceItem)oldItems.get(newKey);
                if (oldItem == null) {
                    resourceItem.setTouched();
                    newItems.put(newKey, resourceItem);
                    continue;
                }
                oldItems.remove(oldItem.getKey());
                if (oldItem.compareValueWith(resourceItem)) continue;
                oldItem.setValue(resourceItem);
            }
            for (ResourceItem resourceItem : oldItems.values()) {
                resourceItem.setRemoved();
            }
            resourceFile.addItems(newItems.values());
            for (Map.Entry entry : newItems.entrySet()) {
                this.addItem((DataItem)entry.getValue(), (String)entry.getKey());
            }
        }
        return true;
    }

    private void parseFolder(File sourceFolder, File folder, FolderData folderData, ILogger logger) throws MergingException {
        File[] files = folder.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                ResourceFile resourceFile;
                if (!file.isFile() || ResourceSet.isIgnored(file) || (resourceFile = ResourceSet.createResourceFile(file, folderData, logger)) == null) continue;
                this.processNewDataFile(sourceFolder, resourceFile, true);
            }
        }
    }

    private static ResourceFile createResourceFile(File file, FolderData folderData, ILogger logger) throws MergingException {
        if (folderData.type != null) {
            String name = file.getName();
            int pos = name.indexOf(46);
            if (pos >= 0) {
                name = name.substring(0, pos);
            }
            return new ResourceFile(file, new ResourceItem(name, folderData.type, null), folderData.qualifiers);
        }
        try {
            ValueResourceParser2 parser = new ValueResourceParser2(file);
            List<ResourceItem> items = parser.parseFile();
            return new ResourceFile(file, items, folderData.qualifiers);
        }
        catch (MergingException e) {
            e.setFile(file);
            logger.error((Throwable)e, "Failed to parse %s", new Object[]{file.getAbsolutePath()});
            throw e;
        }
    }

    @Nullable
    private static FolderData getFolderData(File folder) {
        FolderData fd = new FolderData();
        String folderName = folder.getName();
        int pos = folderName.indexOf("-");
        if (pos != -1) {
            fd.folderType = ResourceFolderType.getTypeByName((String)folderName.substring(0, pos));
            if (fd.folderType == null) {
                return null;
            }
            FolderConfiguration folderConfiguration = FolderConfiguration.getConfigForFolder(folderName);
            if (folderConfiguration == null) {
                return null;
            }
            folderConfiguration.normalize();
            fd.qualifiers = folderConfiguration.getUniqueKey().substring(1);
        } else {
            fd.folderType = ResourceFolderType.getTypeByName((String)folderName);
        }
        if (fd.folderType != null && fd.folderType != ResourceFolderType.VALUES) {
            fd.type = (ResourceType)FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)fd.folderType).get(0);
        }
        return fd;
    }

    private static class FolderData {
        String qualifiers = "";
        ResourceType type = null;
        ResourceFolderType folderType = null;

        private FolderData() {
        }
    }
}

