/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.datasource.xa.session.SessionHandleState;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jms.ConsumerProducerSupport;
import com.atomikos.jms.HeuristicMessageConsumer;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;

class AtomikosJmsMessageConsumerProxy
extends ConsumerProducerSupport
implements HeuristicMessageConsumer {
    private MessageConsumer delegate;

    public AtomikosJmsMessageConsumerProxy(MessageConsumer delegate, SessionHandleState state) {
        super(state);
        this.delegate = delegate;
    }

    protected MessageConsumer getDelegate() {
        return this.delegate;
    }

    public Message receive(String hmsg) throws JMSException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo((String)(this + ": receive ( " + hmsg + " )..."));
        }
        Message ret = null;
        try {
            this.enlist(hmsg);
            ret = this.delegate.receive();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug((String)(this + ": receive returning " + ret));
        }
        return ret;
    }

    public Message receive(long timeout, String hmsg) throws JMSException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo((String)(this + ": receive ( " + timeout + " , " + hmsg + " )..."));
        }
        Message ret = null;
        try {
            this.enlist(hmsg);
            ret = this.delegate.receive(timeout);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug((String)(this + ": receive returning " + ret));
        }
        return ret;
    }

    public Message receiveNoWait(String hmsg) throws JMSException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo((String)(this + ": receiveNoWait ( " + hmsg + " )..."));
        }
        Message ret = null;
        try {
            this.enlist(hmsg);
            ret = this.delegate.receiveNoWait();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug((String)(this + ": receiveNoWait returning " + ret));
        }
        return ret;
    }

    public void close() throws JMSException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo((String)(this + ": close..."));
        }
        try {
            this.delegate.close();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug((String)(this + ": close done."));
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo((String)(this + ": getMessageListener()..."));
        }
        MessageListener ret = null;
        try {
            ret = this.delegate.getMessageListener();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug((String)(this + ": getMessageListener() returning " + ret));
        }
        return ret;
    }

    public String getMessageSelector() throws JMSException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo((String)(this + ": getMessageSelector()..."));
        }
        String ret = null;
        try {
            ret = this.delegate.getMessageSelector();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug((String)(this + ": getMessageSelector() returning " + ret));
        }
        return ret;
    }

    public Message receive() throws JMSException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo((String)(this + ": receive()..."));
        }
        Message ret = this.receive(null);
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug((String)(this + ": receive() returning " + ret));
        }
        return ret;
    }

    public Message receive(long timeout) throws JMSException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo((String)(this + ": receive ( " + timeout + " )..."));
        }
        Message ret = this.receive(timeout, null);
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug((String)(this + ": receive() returning " + ret));
        }
        return ret;
    }

    public Message receiveNoWait() throws JMSException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo((String)(this + ": receiveNoWait()..."));
        }
        Message ret = this.receiveNoWait(null);
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug((String)(this + ": receiveNoWait() returning " + ret));
        }
        return ret;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo((String)(this + ": setMessageListener ( " + listener + " )..."));
        }
        try {
            this.delegate.setMessageListener(listener);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug((String)(this + ": setMessageListener done."));
        }
    }

    public String toString() {
        return "atomikos MessageConsumer proxy for " + this.delegate;
    }
}

