/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.datasource.pool.AbstractXPooledConnection;
import com.atomikos.datasource.pool.ConnectionPoolProperties;
import com.atomikos.datasource.pool.CreateConnectionException;
import com.atomikos.datasource.pool.Reapable;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.datasource.xa.session.SessionHandleStateChangeListener;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jms.AtomikosJmsConnectionProxy;
import com.atomikos.util.DynamicProxy;
import java.lang.reflect.Proxy;
import javax.jms.JMSException;
import javax.jms.XAConnection;

class AtomikosPooledJmsConnection
extends AbstractXPooledConnection
implements SessionHandleStateChangeListener {
    private XAConnection xaConnection;
    private XATransactionalResource jmsTransactionalResource;
    private Reapable currentProxy;
    private ConnectionPoolProperties props;
    private boolean erroneous;

    protected AtomikosPooledJmsConnection(XAConnection xac, XATransactionalResource jmsTransactionalResource, ConnectionPoolProperties props) {
        super(props);
        this.jmsTransactionalResource = jmsTransactionalResource;
        this.xaConnection = xac;
        this.props = props;
        this.erroneous = false;
    }

    protected Reapable doCreateConnectionProxy(HeuristicMessage msg) throws CreateConnectionException {
        this.currentProxy = AtomikosJmsConnectionProxy.newInstance(this.xaConnection, this.jmsTransactionalResource, this, this.props);
        return this.currentProxy;
    }

    protected void testUnderlyingConnection() throws CreateConnectionException {
        if (this.isErroneous()) {
            throw new CreateConnectionException((Object)((Object)this) + ": connection is erroneous");
        }
    }

    public void destroy() {
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug((String)((Object)((Object)this) + ": destroying connection..."));
        }
        if (this.xaConnection != null) {
            try {
                this.xaConnection.close();
            }
            catch (JMSException ex) {
                Configuration.logWarning((String)((Object)((Object)this) + ": error closing XAConnection: "), (Throwable)ex);
            }
        }
        this.xaConnection = null;
    }

    public synchronized boolean isAvailable() {
        boolean ret = true;
        if (this.currentProxy != null) {
            DynamicProxy dproxy = (DynamicProxy)this.currentProxy;
            AtomikosJmsConnectionProxy proxy = (AtomikosJmsConnectionProxy)dproxy.getInvocationHandler();
            ret = proxy.isAvailable();
        }
        return ret;
    }

    public synchronized boolean isErroneous() {
        boolean ret = this.erroneous;
        if (this.currentProxy != null) {
            AtomikosJmsConnectionProxy proxy = (AtomikosJmsConnectionProxy)Proxy.getInvocationHandler(this.currentProxy);
            ret = ret || proxy.isErroneous();
        }
        return ret;
    }

    public synchronized boolean isInTransaction(CompositeTransaction ct) {
        boolean ret = false;
        if (this.currentProxy != null) {
            DynamicProxy dproxy = (DynamicProxy)this.currentProxy;
            AtomikosJmsConnectionProxy proxy = (AtomikosJmsConnectionProxy)dproxy.getInvocationHandler();
            ret = proxy.isInTransaction(ct);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTerminated() {
        boolean fireTerminatedEvent = false;
        AtomikosPooledJmsConnection atomikosPooledJmsConnection = this;
        synchronized (atomikosPooledJmsConnection) {
            DynamicProxy dproxy;
            AtomikosJmsConnectionProxy proxy;
            if (Configuration.isDebugLoggingEnabled()) {
                Configuration.logDebug((String)((Object)((Object)this) + ": a session has terminated, is connection now available ? " + this.isAvailable()));
            }
            if (this.isAvailable()) {
                if (this.currentProxy != null) {
                    DynamicProxy dproxy2 = (DynamicProxy)this.currentProxy;
                    AtomikosJmsConnectionProxy proxy2 = (AtomikosJmsConnectionProxy)dproxy2.getInvocationHandler();
                    if (proxy2.isErroneous()) {
                        this.erroneous = true;
                    }
                    proxy2.destroy();
                }
                fireTerminatedEvent = true;
            } else if (this.currentProxy != null && (proxy = (AtomikosJmsConnectionProxy)(dproxy = (DynamicProxy)this.currentProxy).getInvocationHandler()).isErroneous()) {
                this.erroneous = true;
            }
        }
        if (fireTerminatedEvent) {
            this.fireOnXPooledConnectionTerminated();
        }
    }

    public boolean canBeRecycledForCallingThread() {
        CompositeTransactionManager tm;
        CompositeTransaction current;
        boolean ret = false;
        if (this.currentProxy != null && (current = (tm = Configuration.getCompositeTransactionManager()).getCompositeTransaction()) != null && current.getProperty("com.atomikos.icatch.jta.transaction") != null) {
            DynamicProxy dproxy = (DynamicProxy)this.currentProxy;
            AtomikosJmsConnectionProxy proxy = (AtomikosJmsConnectionProxy)dproxy.getInvocationHandler();
            ret = proxy.isInactiveInTransaction(current) || proxy.isInTransaction(current);
        }
        return ret;
    }

    public String toString() {
        return "atomikos pooled connection for resource " + this.jmsTransactionalResource.getName();
    }
}

