/*
 * Decompiled with CFR 0.152.
 */
package fr.castorflex.android.smoothprogressbar;

import android.content.Context;
import android.util.AttributeSet;
import fr.castorflex.android.smoothprogressbar.SmoothProgressBar;

public class ContentLoadingSmoothProgressBar
extends SmoothProgressBar {
    private static final int MIN_SHOW_TIME = 500;
    private static final int MIN_DELAY = 500;
    private long mStartTime = -1L;
    private boolean mPostedHide = false;
    private boolean mPostedShow = false;
    private boolean mDismissed = false;
    private final Runnable mDelayedHide = new Runnable(){

        @Override
        public void run() {
            ContentLoadingSmoothProgressBar.this.mPostedHide = false;
            ContentLoadingSmoothProgressBar.this.mStartTime = -1L;
            ContentLoadingSmoothProgressBar.this.setVisibility(8);
        }
    };
    private final Runnable mDelayedShow = new Runnable(){

        @Override
        public void run() {
            ContentLoadingSmoothProgressBar.this.mPostedShow = false;
            if (!ContentLoadingSmoothProgressBar.this.mDismissed) {
                ContentLoadingSmoothProgressBar.this.mStartTime = System.currentTimeMillis();
                ContentLoadingSmoothProgressBar.this.setVisibility(0);
            }
        }
    };

    public ContentLoadingSmoothProgressBar(Context context) {
        this(context, null);
    }

    public ContentLoadingSmoothProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.removeCallbacks();
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeCallbacks();
    }

    private void removeCallbacks() {
        this.removeCallbacks(this.mDelayedHide);
        this.removeCallbacks(this.mDelayedShow);
    }

    public void hide() {
        this.mDismissed = true;
        this.removeCallbacks(this.mDelayedShow);
        long diff = System.currentTimeMillis() - this.mStartTime;
        if (diff >= 500L || this.mStartTime == -1L) {
            this.setVisibility(8);
        } else if (!this.mPostedHide) {
            this.postDelayed(this.mDelayedHide, 500L - diff);
            this.mPostedHide = true;
        }
    }

    public void show() {
        this.mStartTime = -1L;
        this.mDismissed = false;
        this.removeCallbacks(this.mDelayedHide);
        if (!this.mPostedShow) {
            this.postDelayed(this.mDelayedShow, 500L);
            this.mPostedShow = true;
        }
    }
}

