/*
 * Decompiled with CFR 0.152.
 */
package fr.castorflex.android.smoothprogressbar;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.ProgressBar;
import fr.castorflex.android.smoothprogressbar.R;
import fr.castorflex.android.smoothprogressbar.SmoothProgressBarUtils;
import fr.castorflex.android.smoothprogressbar.SmoothProgressDrawable;

public class SmoothProgressBar
extends ProgressBar {
    private static final int INTERPOLATOR_ACCELERATE = 0;
    private static final int INTERPOLATOR_LINEAR = 1;
    private static final int INTERPOLATOR_ACCELERATEDECELERATE = 2;
    private static final int INTERPOLATOR_DECELERATE = 3;

    public SmoothProgressBar(Context context) {
        this(context, null);
    }

    public SmoothProgressBar(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.spbStyle);
    }

    public SmoothProgressBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (this.isInEditMode()) {
            this.setIndeterminateDrawable(new SmoothProgressDrawable.Builder(context, true).build());
            return;
        }
        Resources res = context.getResources();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SmoothProgressBar, defStyle, 0);
        int color2 = a.getColor(R.styleable.SmoothProgressBar_spb_color, res.getColor(R.color.spb_default_color));
        int sectionsCount = a.getInteger(R.styleable.SmoothProgressBar_spb_sections_count, res.getInteger(R.integer.spb_default_sections_count));
        int separatorLength = a.getDimensionPixelSize(R.styleable.SmoothProgressBar_spb_stroke_separator_length, res.getDimensionPixelSize(R.dimen.spb_default_stroke_separator_length));
        float strokeWidth = a.getDimension(R.styleable.SmoothProgressBar_spb_stroke_width, res.getDimension(R.dimen.spb_default_stroke_width));
        float speed = a.getFloat(R.styleable.SmoothProgressBar_spb_speed, Float.parseFloat(res.getString(R.string.spb_default_speed)));
        float speedProgressiveStart = a.getFloat(R.styleable.SmoothProgressBar_spb_progressiveStart_speed, speed);
        float speedProgressiveStop = a.getFloat(R.styleable.SmoothProgressBar_spb_progressiveStop_speed, speed);
        int iInterpolator = a.getInteger(R.styleable.SmoothProgressBar_spb_interpolator, -1);
        boolean reversed = a.getBoolean(R.styleable.SmoothProgressBar_spb_reversed, res.getBoolean(R.bool.spb_default_reversed));
        boolean mirrorMode = a.getBoolean(R.styleable.SmoothProgressBar_spb_mirror_mode, res.getBoolean(R.bool.spb_default_mirror_mode));
        int colorsId = a.getResourceId(R.styleable.SmoothProgressBar_spb_colors, 0);
        boolean progressiveStartActivated = a.getBoolean(R.styleable.SmoothProgressBar_spb_progressiveStart_activated, res.getBoolean(R.bool.spb_default_progressiveStart_activated));
        Drawable backgroundDrawable = a.getDrawable(R.styleable.SmoothProgressBar_spb_background);
        boolean generateBackgroundWithColors = a.getBoolean(R.styleable.SmoothProgressBar_spb_generate_background_with_colors, false);
        boolean gradients = a.getBoolean(R.styleable.SmoothProgressBar_spb_gradients, false);
        a.recycle();
        Interpolator interpolator = null;
        if (iInterpolator == -1) {
            interpolator = this.getInterpolator();
        }
        if (interpolator == null) {
            switch (iInterpolator) {
                case 2: {
                    interpolator = new AccelerateDecelerateInterpolator();
                    break;
                }
                case 3: {
                    interpolator = new DecelerateInterpolator();
                    break;
                }
                case 1: {
                    interpolator = new LinearInterpolator();
                    break;
                }
                default: {
                    interpolator = new AccelerateInterpolator();
                }
            }
        }
        int[] colors = null;
        if (colorsId != 0) {
            colors = res.getIntArray(colorsId);
        }
        SmoothProgressDrawable.Builder builder = new SmoothProgressDrawable.Builder(context).speed(speed).progressiveStartSpeed(speedProgressiveStart).progressiveStopSpeed(speedProgressiveStop).interpolator(interpolator).sectionsCount(sectionsCount).separatorLength(separatorLength).strokeWidth(strokeWidth).reversed(reversed).mirrorMode(mirrorMode).progressiveStart(progressiveStartActivated).gradients(gradients);
        if (backgroundDrawable != null) {
            builder.backgroundDrawable(backgroundDrawable);
        }
        if (generateBackgroundWithColors) {
            builder.generateBackgroundUsingColors();
        }
        if (colors != null && colors.length > 0) {
            builder.colors(colors);
        } else {
            builder.color(color2);
        }
        SmoothProgressDrawable d = builder.build();
        this.setIndeterminateDrawable(d);
    }

    public void applyStyle(int styleResId) {
        int[] colors;
        int colorsId;
        TypedArray a = this.getContext().obtainStyledAttributes(null, R.styleable.SmoothProgressBar, 0, styleResId);
        if (a.hasValue(R.styleable.SmoothProgressBar_spb_color)) {
            this.setSmoothProgressDrawableColor(a.getColor(R.styleable.SmoothProgressBar_spb_color, 0));
        }
        if (a.hasValue(R.styleable.SmoothProgressBar_spb_colors) && (colorsId = a.getResourceId(R.styleable.SmoothProgressBar_spb_colors, 0)) != 0 && (colors = this.getResources().getIntArray(colorsId)) != null && colors.length > 0) {
            this.setSmoothProgressDrawableColors(colors);
        }
        if (a.hasValue(R.styleable.SmoothProgressBar_spb_sections_count)) {
            this.setSmoothProgressDrawableSectionsCount(a.getInteger(R.styleable.SmoothProgressBar_spb_sections_count, 0));
        }
        if (a.hasValue(R.styleable.SmoothProgressBar_spb_stroke_separator_length)) {
            this.setSmoothProgressDrawableSeparatorLength(a.getDimensionPixelSize(R.styleable.SmoothProgressBar_spb_stroke_separator_length, 0));
        }
        if (a.hasValue(R.styleable.SmoothProgressBar_spb_stroke_width)) {
            this.setSmoothProgressDrawableStrokeWidth(a.getDimension(R.styleable.SmoothProgressBar_spb_stroke_width, 0.0f));
        }
        if (a.hasValue(R.styleable.SmoothProgressBar_spb_speed)) {
            this.setSmoothProgressDrawableSpeed(a.getFloat(R.styleable.SmoothProgressBar_spb_speed, 0.0f));
        }
        if (a.hasValue(R.styleable.SmoothProgressBar_spb_progressiveStart_speed)) {
            this.setSmoothProgressDrawableProgressiveStartSpeed(a.getFloat(R.styleable.SmoothProgressBar_spb_progressiveStart_speed, 0.0f));
        }
        if (a.hasValue(R.styleable.SmoothProgressBar_spb_progressiveStop_speed)) {
            this.setSmoothProgressDrawableProgressiveStopSpeed(a.getFloat(R.styleable.SmoothProgressBar_spb_progressiveStop_speed, 0.0f));
        }
        if (a.hasValue(R.styleable.SmoothProgressBar_spb_reversed)) {
            this.setSmoothProgressDrawableReversed(a.getBoolean(R.styleable.SmoothProgressBar_spb_reversed, false));
        }
        if (a.hasValue(R.styleable.SmoothProgressBar_spb_mirror_mode)) {
            this.setSmoothProgressDrawableMirrorMode(a.getBoolean(R.styleable.SmoothProgressBar_spb_mirror_mode, false));
        }
        if (a.hasValue(R.styleable.SmoothProgressBar_spb_progressiveStart_activated)) {
            this.setProgressiveStartActivated(a.getBoolean(R.styleable.SmoothProgressBar_spb_progressiveStart_activated, false));
        }
        if (a.hasValue(R.styleable.SmoothProgressBar_spb_progressiveStart_activated)) {
            this.setProgressiveStartActivated(a.getBoolean(R.styleable.SmoothProgressBar_spb_progressiveStart_activated, false));
        }
        if (a.hasValue(R.styleable.SmoothProgressBar_spb_gradients)) {
            this.setSmoothProgressDrawableUseGradients(a.getBoolean(R.styleable.SmoothProgressBar_spb_gradients, false));
        }
        if (a.hasValue(R.styleable.SmoothProgressBar_spb_generate_background_with_colors) && a.getBoolean(R.styleable.SmoothProgressBar_spb_generate_background_with_colors, false)) {
            this.setSmoothProgressDrawableBackgroundDrawable(SmoothProgressBarUtils.generateDrawableWithColors(this.checkIndeterminateDrawable().getColors(), this.checkIndeterminateDrawable().getStrokeWidth()));
        }
        if (a.hasValue(R.styleable.SmoothProgressBar_spb_interpolator)) {
            AccelerateDecelerateInterpolator interpolator;
            int iInterpolator = a.getInteger(R.styleable.SmoothProgressBar_spb_interpolator, -1);
            switch (iInterpolator) {
                case 2: {
                    interpolator = new AccelerateDecelerateInterpolator();
                    break;
                }
                case 3: {
                    interpolator = new DecelerateInterpolator();
                    break;
                }
                case 1: {
                    interpolator = new LinearInterpolator();
                    break;
                }
                case 0: {
                    interpolator = new AccelerateInterpolator();
                    break;
                }
                default: {
                    interpolator = null;
                }
            }
            if (interpolator != null) {
                this.setInterpolator((Interpolator)interpolator);
            }
        }
        a.recycle();
    }

    protected synchronized void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isIndeterminate() && this.getIndeterminateDrawable() instanceof SmoothProgressDrawable && !((SmoothProgressDrawable)this.getIndeterminateDrawable()).isRunning()) {
            this.getIndeterminateDrawable().draw(canvas);
        }
    }

    private SmoothProgressDrawable checkIndeterminateDrawable() {
        Drawable ret = this.getIndeterminateDrawable();
        if (ret == null || !(ret instanceof SmoothProgressDrawable)) {
            throw new RuntimeException("The drawable is not a SmoothProgressDrawable");
        }
        return (SmoothProgressDrawable)ret;
    }

    public void setInterpolator(Interpolator interpolator) {
        super.setInterpolator(interpolator);
        Drawable ret = this.getIndeterminateDrawable();
        if (ret != null && ret instanceof SmoothProgressDrawable) {
            ((SmoothProgressDrawable)ret).setInterpolator(interpolator);
        }
    }

    public void setSmoothProgressDrawableInterpolator(Interpolator interpolator) {
        this.checkIndeterminateDrawable().setInterpolator(interpolator);
    }

    public void setSmoothProgressDrawableColors(int[] colors) {
        this.checkIndeterminateDrawable().setColors(colors);
    }

    public void setSmoothProgressDrawableColor(int color2) {
        this.checkIndeterminateDrawable().setColor(color2);
    }

    public void setSmoothProgressDrawableSpeed(float speed) {
        this.checkIndeterminateDrawable().setSpeed(speed);
    }

    public void setSmoothProgressDrawableProgressiveStartSpeed(float speed) {
        this.checkIndeterminateDrawable().setProgressiveStartSpeed(speed);
    }

    public void setSmoothProgressDrawableProgressiveStopSpeed(float speed) {
        this.checkIndeterminateDrawable().setProgressiveStopSpeed(speed);
    }

    public void setSmoothProgressDrawableSectionsCount(int sectionsCount) {
        this.checkIndeterminateDrawable().setSectionsCount(sectionsCount);
    }

    public void setSmoothProgressDrawableSeparatorLength(int separatorLength) {
        this.checkIndeterminateDrawable().setSeparatorLength(separatorLength);
    }

    public void setSmoothProgressDrawableStrokeWidth(float strokeWidth) {
        this.checkIndeterminateDrawable().setStrokeWidth(strokeWidth);
    }

    public void setSmoothProgressDrawableReversed(boolean reversed) {
        this.checkIndeterminateDrawable().setReversed(reversed);
    }

    public void setSmoothProgressDrawableMirrorMode(boolean mirrorMode) {
        this.checkIndeterminateDrawable().setMirrorMode(mirrorMode);
    }

    public void setProgressiveStartActivated(boolean progressiveStartActivated) {
        this.checkIndeterminateDrawable().setProgressiveStartActivated(progressiveStartActivated);
    }

    public void setSmoothProgressDrawableCallbacks(SmoothProgressDrawable.Callbacks listener) {
        this.checkIndeterminateDrawable().setCallbacks(listener);
    }

    public void setSmoothProgressDrawableBackgroundDrawable(Drawable drawable) {
        this.checkIndeterminateDrawable().setBackgroundDrawable(drawable);
    }

    public void setSmoothProgressDrawableUseGradients(boolean useGradients) {
        this.checkIndeterminateDrawable().setUseGradients(useGradients);
    }

    public void progressiveStart() {
        this.checkIndeterminateDrawable().progressiveStart();
    }

    public void progressiveStop() {
        this.checkIndeterminateDrawable().progressiveStop();
    }
}

