/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.mojo;

import com.github.searls.jasmine.config.JasmineConfiguration;
import com.github.searls.jasmine.exception.StringifiesStackTraces;
import com.github.searls.jasmine.io.ScansDirectory;
import com.github.searls.jasmine.model.ScriptSearch;
import com.github.searls.jasmine.mojo.Capability;
import com.github.searls.jasmine.mojo.Context;
import com.github.searls.jasmine.runner.SpecRunnerTemplate;
import com.github.searls.jasmine.thirdpartylibs.ProjectClassLoaderFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.resource.ResourceManager;
import org.eclipse.jetty.server.Connector;

public abstract class AbstractJasmineMojo
extends AbstractMojo
implements JasmineConfiguration {
    private static final String ERROR_FILE_DNE = "Invalid value for parameter '%s'. File does not exist: %s";
    @Parameter(property="jsSrcDir", defaultValue="${project.basedir}${file.separator}src${file.separator}main${file.separator}javascript")
    private File jsSrcDir;
    @Parameter(property="jsTestSrcDir", defaultValue="${project.basedir}${file.separator}src${file.separator}test${file.separator}javascript")
    private File jsTestSrcDir;
    @Parameter(defaultValue="org.openqa.selenium.htmlunit.HtmlUnitDriver")
    protected String webDriverClassName;
    @Parameter
    protected List<Capability> webDriverCapabilities = Collections.emptyList();
    @Parameter(defaultValue="FIREFOX_17")
    protected String browserVersion;
    @Parameter(defaultValue="documentation")
    protected String format;
    @Parameter
    protected List<String> preloadSources;
    @Parameter
    protected String customRunnerTemplate;
    @Parameter
    protected String customRunnerConfiguration;
    @Parameter(defaultValue="${project.build.directory}${file.separator}jasmine")
    protected File jasmineTargetDir;
    @Parameter(property="skipTests")
    protected boolean skipTests;
    @Parameter(property="maven.test.skip")
    protected boolean mvnTestSkip;
    @Parameter(property="skipJasmineTests")
    protected boolean skipJasmineTests;
    @Parameter(property="haltOnFailure", defaultValue="true")
    protected boolean haltOnFailure;
    @Parameter(defaultValue="300")
    protected int timeout;
    @Parameter(defaultValue="false")
    protected boolean debug;
    @Parameter(defaultValue="SpecRunner.html")
    protected String specRunnerHtmlFileName;
    @Parameter(defaultValue="ManualSpecRunner.html")
    protected String manualSpecRunnerHtmlFileName;
    @Parameter(defaultValue="TEST-jasmine.xml")
    protected String junitXmlReportFileName;
    @Parameter(defaultValue="spec")
    protected String specDirectoryName;
    @Parameter(defaultValue="src")
    protected String srcDirectoryName;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    protected String sourceEncoding;
    @Parameter(property="keepServerAlive", defaultValue="false")
    protected boolean keepServerAlive;
    @Parameter
    private final List<String> sourceIncludes = ScansDirectory.DEFAULT_INCLUDES;
    @Parameter
    private final List<String> sourceExcludes = Collections.emptyList();
    @Parameter
    private final List<String> specIncludes = ScansDirectory.DEFAULT_INCLUDES;
    @Parameter
    private final List<String> specExcludes = Collections.emptyList();
    @Parameter(property="jasmine.serverPort", defaultValue="8234")
    protected int serverPort;
    @Parameter(property="jasmine.uriScheme", defaultValue="http")
    protected String uriScheme;
    @Parameter(property="jasmine.serverHostname", defaultValue="localhost")
    protected String serverHostname;
    @Parameter(property="jasmine.specRunnerTemplate", defaultValue="DEFAULT")
    protected SpecRunnerTemplate specRunnerTemplate;
    @Deprecated
    @Parameter
    protected String scriptLoaderPath;
    @Parameter(property="jasmine.autoRefreshInterval", defaultValue="0")
    protected int autoRefreshInterval;
    @Parameter(property="coffeeScriptCompilationEnabled", defaultValue="true")
    protected boolean coffeeScriptCompilationEnabled;
    @Parameter(property="jasmine.connectorClass", defaultValue="org.eclipse.jetty.server.nio.SelectChannelConnector")
    protected String connectorClass;
    @Parameter
    private List<Context> additionalContexts = Collections.emptyList();
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject mavenProject;
    @Component
    protected ResourceManager locator;
    protected ScriptSearch sources;
    protected ScriptSearch specs;
    protected StringifiesStackTraces stringifiesStackTraces = new StringifiesStackTraces();
    private File customRunnerTemplateFile;
    private File customRunnerConfigurationFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.loadResources();
        this.sources = new ScriptSearch(this.jsSrcDir, this.sourceIncludes, this.sourceExcludes);
        this.specs = new ScriptSearch(this.jsTestSrcDir, this.specIncludes, this.specExcludes);
        try {
            this.run();
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("The jasmine-maven-plugin encountered an exception: \n" + this.stringifiesStackTraces.stringify(e), e);
        }
    }

    public abstract void run() throws Exception;

    @Override
    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    @Override
    public File getCustomRunnerTemplate() {
        return this.customRunnerTemplateFile;
    }

    @Override
    public SpecRunnerTemplate getSpecRunnerTemplate() {
        return this.specRunnerTemplate;
    }

    @Override
    public File getJasmineTargetDir() {
        return this.jasmineTargetDir;
    }

    @Override
    public String getSrcDirectoryName() {
        return this.srcDirectoryName;
    }

    @Override
    public ScriptSearch getSources() {
        return this.sources;
    }

    @Override
    public ScriptSearch getSpecs() {
        return this.specs;
    }

    @Override
    public String getSpecDirectoryName() {
        return this.specDirectoryName;
    }

    @Override
    public List<String> getPreloadSources() {
        this.addRequireJsIfNecessary();
        return this.preloadSources;
    }

    private void addRequireJsIfNecessary() {
        File requireJsFile;
        String scriptLoaderPath = this.getScriptLoaderPath() == null ? "require.js" : this.getScriptLoaderPath();
        String requireJsPath = String.format("%s/%s", this.jsSrcDir, scriptLoaderPath);
        if (SpecRunnerTemplate.REQUIRE_JS.equals((Object)this.specRunnerTemplate) && (requireJsFile = new File(requireJsPath)).exists()) {
            if (this.preloadSources == null) {
                this.preloadSources = new ArrayList<String>();
            }
            this.preloadSources.add(requireJsPath);
        }
    }

    @Override
    public int getAutoRefreshInterval() {
        return this.autoRefreshInterval;
    }

    @Override
    public boolean isCoffeeScriptCompilationEnabled() {
        return this.coffeeScriptCompilationEnabled;
    }

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    @Override
    public File getCustomRunnerConfiguration() {
        return this.customRunnerConfigurationFile;
    }

    @Override
    @Deprecated
    public String getScriptLoaderPath() {
        return this.scriptLoaderPath;
    }

    @Override
    public File getBasedir() {
        return this.mavenProject.getBasedir();
    }

    @Override
    public ClassLoader getProjectClassLoader() {
        return new ProjectClassLoaderFactory(this.mavenProject.getArtifacts()).create();
    }

    @Override
    public List<Context> getContexts() {
        ArrayList<Context> contexts = new ArrayList<Context>();
        contexts.add(new Context(this.srcDirectoryName, this.jsSrcDir));
        contexts.add(new Context(this.specDirectoryName, this.jsTestSrcDir));
        contexts.addAll(this.additionalContexts);
        return contexts;
    }

    protected Connector getConnector() throws MojoExecutionException {
        try {
            Class<?> c = Class.forName(this.connectorClass);
            return (Connector)c.newInstance();
        }
        catch (InstantiationException e) {
            throw new MojoExecutionException("Unable to instantiate.", (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException("Unable to instantiate.", (Exception)e);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Unable to instantiate.", (Exception)e);
        }
    }

    protected boolean isSkipTests() {
        return this.skipTests || this.mvnTestSkip || this.skipJasmineTests;
    }

    private void loadResources() throws MojoExecutionException {
        this.customRunnerTemplateFile = this.getResourceAsFile("customRunnerTemplate", this.customRunnerTemplate);
        this.customRunnerConfigurationFile = this.getResourceAsFile("customRunnerConfiguration", this.customRunnerConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getResourceAsFile(String parameter, String resourceLocation) throws MojoExecutionException {
        File file = null;
        if (resourceLocation != null) {
            this.locator.addSearchPath("url", "");
            this.locator.addSearchPath("file", this.mavenProject.getFile().getParentFile().getAbsolutePath());
            ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                try {
                    file = this.locator.getResourceAsFile(resourceLocation);
                }
                catch (Exception e) {
                    throw new MojoExecutionException(String.format(ERROR_FILE_DNE, parameter, resourceLocation));
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(origLoader);
            }
        }
        return file;
    }
}

