/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import com.google.api.client.util.Key;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.internal.NonNull;
import com.google.firebase.messaging.LightSettings;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class AndroidNotification {
    @Key(value="title")
    private final String title;
    @Key(value="body")
    private final String body;
    @Key(value="icon")
    private final String icon;
    @Key(value="color")
    private final String color;
    @Key(value="sound")
    private final String sound;
    @Key(value="tag")
    private final String tag;
    @Key(value="click_action")
    private final String clickAction;
    @Key(value="body_loc_key")
    private final String bodyLocKey;
    @Key(value="body_loc_args")
    private final List<String> bodyLocArgs;
    @Key(value="title_loc_key")
    private final String titleLocKey;
    @Key(value="title_loc_args")
    private final List<String> titleLocArgs;
    @Key(value="channel_id")
    private final String channelId;
    @Key(value="image")
    private final String image;
    @Key(value="ticker")
    private final String ticker;
    @Key(value="sticky")
    private final Boolean sticky;
    @Key(value="event_time")
    private final String eventTime;
    @Key(value="local_only")
    private final Boolean localOnly;
    @Key(value="notification_priority")
    private final String priority;
    @Key(value="vibrate_timings")
    private final List<String> vibrateTimings;
    @Key(value="default_vibrate_timings")
    private final Boolean defaultVibrateTimings;
    @Key(value="default_sound")
    private final Boolean defaultSound;
    @Key(value="light_settings")
    private final LightSettings lightSettings;
    @Key(value="default_light_settings")
    private final Boolean defaultLightSettings;
    @Key(value="visibility")
    private final String visibility;
    @Key(value="notification_count")
    private final Integer notificationCount;
    private static final Map<Priority, String> PRIORITY_MAP = ImmutableMap.builder().put((Object)Priority.MIN, (Object)"PRIORITY_MIN").put((Object)Priority.LOW, (Object)"PRIORITY_LOW").put((Object)Priority.DEFAULT, (Object)"PRIORITY_DEFAULT").put((Object)Priority.HIGH, (Object)"PRIORITY_HIGH").put((Object)Priority.MAX, (Object)"PRIORITY_MAX").build();

    private AndroidNotification(Builder builder) {
        this.title = builder.title;
        this.body = builder.body;
        this.icon = builder.icon;
        if (builder.color != null) {
            Preconditions.checkArgument((boolean)builder.color.matches("^#[0-9a-fA-F]{6}$"), (Object)"color must be in the form #RRGGBB");
        }
        this.color = builder.color;
        this.sound = builder.sound;
        this.tag = builder.tag;
        this.clickAction = builder.clickAction;
        this.bodyLocKey = builder.bodyLocKey;
        if (!builder.bodyLocArgs.isEmpty()) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)builder.bodyLocKey) ? 1 : 0) != 0, (Object)"bodyLocKey is required when specifying bodyLocArgs");
            this.bodyLocArgs = ImmutableList.copyOf((Collection)builder.bodyLocArgs);
        } else {
            this.bodyLocArgs = null;
        }
        this.titleLocKey = builder.titleLocKey;
        if (!builder.titleLocArgs.isEmpty()) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)builder.titleLocKey) ? 1 : 0) != 0, (Object)"titleLocKey is required when specifying titleLocArgs");
            this.titleLocArgs = ImmutableList.copyOf((Collection)builder.titleLocArgs);
        } else {
            this.titleLocArgs = null;
        }
        this.channelId = builder.channelId;
        this.image = builder.image;
        this.ticker = builder.ticker;
        this.sticky = builder.sticky;
        this.eventTime = builder.eventTime;
        this.localOnly = builder.localOnly;
        this.priority = builder.priority != null ? builder.priority.toString() : null;
        this.vibrateTimings = !builder.vibrateTimings.isEmpty() ? ImmutableList.copyOf((Collection)builder.vibrateTimings) : null;
        this.defaultVibrateTimings = builder.defaultVibrateTimings;
        this.defaultSound = builder.defaultSound;
        this.lightSettings = builder.lightSettings;
        this.defaultLightSettings = builder.defaultLightSettings;
        this.visibility = builder.visibility != null ? builder.visibility.name().toLowerCase() : null;
        this.notificationCount = builder.notificationCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String title;
        private String body;
        private String icon;
        private String color;
        private String sound;
        private String tag;
        private String clickAction;
        private String bodyLocKey;
        private List<String> bodyLocArgs = new ArrayList<String>();
        private String titleLocKey;
        private List<String> titleLocArgs = new ArrayList<String>();
        private String channelId;
        private String image;
        private String ticker;
        private Boolean sticky;
        private String eventTime;
        private Boolean localOnly;
        private Priority priority;
        private List<String> vibrateTimings = new ArrayList<String>();
        private Boolean defaultVibrateTimings;
        private Boolean defaultSound;
        private LightSettings lightSettings;
        private Boolean defaultLightSettings;
        private Visibility visibility;
        private Integer notificationCount;

        private Builder() {
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setBody(String body) {
            this.body = body;
            return this;
        }

        public Builder setIcon(String icon) {
            this.icon = icon;
            return this;
        }

        public Builder setColor(String color) {
            this.color = color;
            return this;
        }

        public Builder setSound(String sound) {
            this.sound = sound;
            return this;
        }

        public Builder setTag(String tag) {
            this.tag = tag;
            return this;
        }

        public Builder setClickAction(String clickAction) {
            this.clickAction = clickAction;
            return this;
        }

        public Builder setBodyLocalizationKey(String bodyLocKey) {
            this.bodyLocKey = bodyLocKey;
            return this;
        }

        public Builder addBodyLocalizationArg(@NonNull String arg) {
            this.bodyLocArgs.add(arg);
            return this;
        }

        public Builder addAllBodyLocalizationArgs(@NonNull List<String> args) {
            this.bodyLocArgs.addAll(args);
            return this;
        }

        public Builder setTitleLocalizationKey(String titleLocKey) {
            this.titleLocKey = titleLocKey;
            return this;
        }

        public Builder addTitleLocalizationArg(@NonNull String arg) {
            this.titleLocArgs.add(arg);
            return this;
        }

        public Builder addAllTitleLocalizationArgs(@NonNull List<String> args) {
            this.titleLocArgs.addAll(args);
            return this;
        }

        public Builder setChannelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public Builder setImage(String imageUrl) {
            this.image = imageUrl;
            return this;
        }

        public Builder setTicker(String ticker) {
            this.ticker = ticker;
            return this;
        }

        public Builder setSticky(boolean sticky) {
            this.sticky = sticky;
            return this;
        }

        public Builder setEventTimeInMillis(long eventTimeInMillis) {
            this.eventTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS'Z'").format(new Date(eventTimeInMillis));
            return this;
        }

        public Builder setLocalOnly(boolean localOnly) {
            this.localOnly = localOnly;
            return this;
        }

        public Builder setPriority(Priority priority) {
            this.priority = priority;
            return this;
        }

        public Builder setVibrateTimingsInMillis(long[] vibrateTimingsInMillis) {
            ArrayList<String> list = new ArrayList<String>();
            for (long value : vibrateTimingsInMillis) {
                Preconditions.checkArgument((value >= 0L ? 1 : 0) != 0, (Object)"elements in vibrateTimingsInMillis must not be negative");
                long seconds = TimeUnit.MILLISECONDS.toSeconds(value);
                long subsecondNanos = TimeUnit.MILLISECONDS.toNanos(value - seconds * 1000L);
                if (subsecondNanos > 0L) {
                    list.add(String.format("%d.%09ds", seconds, subsecondNanos));
                    continue;
                }
                list.add(String.format("%ds", seconds));
            }
            this.vibrateTimings = ImmutableList.copyOf(list);
            return this;
        }

        public Builder setDefaultVibrateTimings(boolean defaultVibrateTimings) {
            this.defaultVibrateTimings = defaultVibrateTimings;
            return this;
        }

        public Builder setDefaultSound(boolean defaultSound) {
            this.defaultSound = defaultSound;
            return this;
        }

        public Builder setLightSettings(LightSettings lightSettings) {
            this.lightSettings = lightSettings;
            return this;
        }

        public Builder setDefaultLightSettings(boolean defaultLightSettings) {
            this.defaultLightSettings = defaultLightSettings;
            return this;
        }

        public Builder setVisibility(Visibility visibility) {
            this.visibility = visibility;
            return this;
        }

        public Builder setNotificationCount(int notificationCount) {
            this.notificationCount = notificationCount;
            return this;
        }

        public AndroidNotification build() {
            return new AndroidNotification(this);
        }
    }

    public static enum Visibility {
        PRIVATE,
        PUBLIC,
        SECRET;

    }

    public static enum Priority {
        MIN,
        LOW,
        DEFAULT,
        HIGH,
        MAX;


        public String toString() {
            return (String)PRIORITY_MAP.get((Object)this);
        }
    }
}

