/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import com.google.api.client.util.Key;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.internal.NonNull;
import com.google.firebase.messaging.AndroidNotification;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class AndroidConfig {
    @Key(value="collapse_key")
    private final String collapseKey;
    @Key(value="priority")
    private final String priority;
    @Key(value="ttl")
    private final String ttl;
    @Key(value="restricted_package_name")
    private final String restrictedPackageName;
    @Key(value="data")
    private final Map<String, String> data;
    @Key(value="notification")
    private final AndroidNotification notification;

    private AndroidConfig(Builder builder) {
        this.collapseKey = builder.collapseKey;
        this.priority = builder.priority != null ? builder.priority.name().toLowerCase() : null;
        if (builder.ttl != null) {
            Preconditions.checkArgument((builder.ttl >= 0L ? 1 : 0) != 0, (Object)"ttl must not be negative");
            long seconds = TimeUnit.MILLISECONDS.toSeconds(builder.ttl);
            long subsecondNanos = TimeUnit.MILLISECONDS.toNanos(builder.ttl - seconds * 1000L);
            this.ttl = subsecondNanos > 0L ? String.format("%d.%09ds", seconds, subsecondNanos) : String.format("%ds", seconds);
        } else {
            this.ttl = null;
        }
        this.restrictedPackageName = builder.restrictedPackageName;
        this.data = builder.data.isEmpty() ? null : ImmutableMap.copyOf((Map)builder.data);
        this.notification = builder.notification;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String collapseKey;
        private Priority priority;
        private Long ttl;
        private String restrictedPackageName;
        private final Map<String, String> data = new HashMap<String, String>();
        private AndroidNotification notification;

        private Builder() {
        }

        public Builder setCollapseKey(String collapseKey) {
            this.collapseKey = collapseKey;
            return this;
        }

        public Builder setPriority(Priority priority) {
            this.priority = priority;
            return this;
        }

        public Builder setTtl(long ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder setRestrictedPackageName(String restrictedPackageName) {
            this.restrictedPackageName = restrictedPackageName;
            return this;
        }

        public Builder putData(@NonNull String key, @NonNull String value) {
            this.data.put(key, value);
            return this;
        }

        public Builder putAllData(@NonNull Map<String, String> map) {
            this.data.putAll(map);
            return this;
        }

        public Builder setNotification(AndroidNotification notification) {
            this.notification = notification;
            return this;
        }

        public AndroidConfig build() {
            return new AndroidConfig(this);
        }
    }

    public static enum Priority {
        HIGH,
        NORMAL;

    }
}

