/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import com.google.api.client.util.Key;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.firebase.internal.NonNull;
import com.google.firebase.messaging.AndroidConfig;
import com.google.firebase.messaging.ApnsConfig;
import com.google.firebase.messaging.Notification;
import com.google.firebase.messaging.WebpushConfig;
import java.util.HashMap;
import java.util.Map;

public class Message {
    @Key(value="data")
    private final Map<String, String> data;
    @Key(value="notification")
    private final Notification notification;
    @Key(value="android")
    private final AndroidConfig androidConfig;
    @Key(value="webpush")
    private final WebpushConfig webpushConfig;
    @Key(value="apns")
    private final ApnsConfig apnsConfig;
    @Key(value="token")
    private final String token;
    @Key(value="topic")
    private final String topic;
    @Key(value="condition")
    private final String condition;

    private Message(Builder builder) {
        this.data = builder.data.isEmpty() ? null : ImmutableMap.copyOf((Map)builder.data);
        this.notification = builder.notification;
        this.androidConfig = builder.androidConfig;
        this.webpushConfig = builder.webpushConfig;
        this.apnsConfig = builder.apnsConfig;
        int count = Booleans.countTrue((boolean[])new boolean[]{!Strings.isNullOrEmpty((String)builder.token), !Strings.isNullOrEmpty((String)builder.topic), !Strings.isNullOrEmpty((String)builder.condition)});
        Preconditions.checkArgument((count == 1 ? 1 : 0) != 0, (Object)"Exactly one of token, topic or condition must be specified");
        this.token = builder.token;
        this.topic = Message.stripPrefix(builder.topic);
        this.condition = builder.condition;
    }

    @VisibleForTesting
    Map<String, String> getData() {
        return this.data;
    }

    @VisibleForTesting
    Notification getNotification() {
        return this.notification;
    }

    @VisibleForTesting
    AndroidConfig getAndroidConfig() {
        return this.androidConfig;
    }

    @VisibleForTesting
    WebpushConfig getWebpushConfig() {
        return this.webpushConfig;
    }

    @VisibleForTesting
    ApnsConfig getApnsConfig() {
        return this.apnsConfig;
    }

    @VisibleForTesting
    String getToken() {
        return this.token;
    }

    @VisibleForTesting
    String getTopic() {
        return this.topic;
    }

    @VisibleForTesting
    String getCondition() {
        return this.condition;
    }

    Map<String, Object> wrapForTransport(boolean dryRun) {
        ImmutableMap.Builder payload = ImmutableMap.builder().put((Object)"message", (Object)this);
        if (dryRun) {
            payload.put((Object)"validate_only", (Object)true);
        }
        return payload.build();
    }

    private static String stripPrefix(String topic) {
        if (Strings.isNullOrEmpty((String)topic)) {
            return null;
        }
        if (topic.startsWith("/topics/")) {
            topic = topic.replaceFirst("^/topics/", "");
        }
        Preconditions.checkArgument((boolean)topic.matches("[a-zA-Z0-9-_.~%]+"), (Object)"Malformed topic name");
        return topic;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, String> data = new HashMap<String, String>();
        private Notification notification;
        private AndroidConfig androidConfig;
        private WebpushConfig webpushConfig;
        private ApnsConfig apnsConfig;
        private String token;
        private String topic;
        private String condition;

        private Builder() {
        }

        public Builder setNotification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public Builder setAndroidConfig(AndroidConfig androidConfig) {
            this.androidConfig = androidConfig;
            return this;
        }

        public Builder setWebpushConfig(WebpushConfig webpushConfig) {
            this.webpushConfig = webpushConfig;
            return this;
        }

        public Builder setApnsConfig(ApnsConfig apnsConfig) {
            this.apnsConfig = apnsConfig;
            return this;
        }

        public Builder setToken(String token) {
            this.token = token;
            return this;
        }

        public Builder setTopic(String topic) {
            this.topic = topic;
            return this;
        }

        public Builder setCondition(String condition) {
            this.condition = condition;
            return this;
        }

        public Builder putData(@NonNull String key, @NonNull String value) {
            this.data.put(key, value);
            return this;
        }

        public Builder putAllData(@NonNull Map<String, String> map) {
            this.data.putAll(map);
            return this;
        }

        public Message build() {
            return new Message(this);
        }
    }
}

