/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.api.client.util.Key;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.auth.ProviderConfig;

public final class OidcProviderConfig
extends ProviderConfig {
    @Key(value="clientId")
    private String clientId;
    @Key(value="issuer")
    private String issuer;

    public String getClientId() {
        return this.clientId;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public UpdateRequest updateRequest() {
        return new UpdateRequest(this.getProviderId());
    }

    static void checkOidcProviderId(String providerId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)providerId) ? 1 : 0) != 0, (Object)"Provider ID must not be null or empty.");
        Preconditions.checkArgument((boolean)providerId.startsWith("oidc."), (Object)("Invalid OIDC provider ID (must be prefixed with 'oidc.'): " + providerId));
    }

    public static final class UpdateRequest
    extends ProviderConfig.AbstractUpdateRequest<UpdateRequest> {
        public UpdateRequest(String providerId) {
            super(providerId);
            OidcProviderConfig.checkOidcProviderId(providerId);
        }

        public UpdateRequest setClientId(String clientId) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)clientId) ? 1 : 0) != 0, (Object)"Client ID must not be null or empty.");
            this.properties.put("clientId", clientId);
            return this;
        }

        public UpdateRequest setIssuer(String issuer) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)issuer) ? 1 : 0) != 0, (Object)"Issuer must not be null or empty.");
            ProviderConfig.assertValidUrl(issuer);
            this.properties.put("issuer", issuer);
            return this;
        }

        @Override
        UpdateRequest getThis() {
            return this;
        }
    }

    public static final class CreateRequest
    extends ProviderConfig.AbstractCreateRequest<CreateRequest> {
        @Override
        public CreateRequest setProviderId(String providerId) {
            OidcProviderConfig.checkOidcProviderId(providerId);
            return (CreateRequest)super.setProviderId(providerId);
        }

        public CreateRequest setClientId(String clientId) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)clientId) ? 1 : 0) != 0, (Object)"Client ID must not be null or empty.");
            this.properties.put("clientId", clientId);
            return this;
        }

        public CreateRequest setIssuer(String issuer) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)issuer) ? 1 : 0) != 0, (Object)"Issuer must not be null or empty.");
            ProviderConfig.assertValidUrl(issuer);
            this.properties.put("issuer", issuer);
            return this;
        }

        @Override
        CreateRequest getThis() {
            return this;
        }
    }
}

