/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.google.common.collect.ImmutableList;
import com.mysema.query.Tuple;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.types.CollectionExpression;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.Operator;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.ProjectionRole;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.expr.BooleanOperation;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PrimaryKey<E>
implements Serializable,
ProjectionRole<Tuple> {
    private static final long serialVersionUID = -6913344535043394649L;
    private final RelationalPath<?> entity;
    private final ImmutableList<? extends Path<?>> localColumns;
    @Nullable
    private volatile Expression<Tuple> mixin;

    public PrimaryKey(RelationalPath<?> entity, Path<?> ... localColumns) {
        this(entity, ImmutableList.copyOf((Object[])localColumns));
    }

    public PrimaryKey(RelationalPath<?> entity, ImmutableList<? extends Path<?>> localColumns) {
        this.entity = entity;
        this.localColumns = localColumns;
        this.mixin = ExpressionUtils.list(Tuple.class, localColumns);
    }

    public RelationalPath<?> getEntity() {
        return this.entity;
    }

    public List<? extends Path<?>> getLocalColumns() {
        return this.localColumns;
    }

    public BooleanExpression in(CollectionExpression<?, Tuple> coll) {
        return BooleanOperation.create((Operator)Ops.IN, this.getProjection(), coll);
    }

    public Expression<Tuple> getProjection() {
        if (this.mixin == null) {
            this.mixin = ExpressionUtils.list(Tuple.class, this.localColumns);
        }
        return this.mixin;
    }
}

