/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.google.common.collect.ImmutableList;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.MutableExpressionBase;
import com.mysema.query.types.Operator;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.TemplateFactory;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.ComparableExpressionBase;
import com.mysema.query.types.expr.SimpleExpression;
import com.mysema.query.types.expr.SimpleOperation;
import com.mysema.query.types.template.SimpleTemplate;
import java.util.ArrayList;
import java.util.List;

public class WithinGroup<T>
extends SimpleOperation<T> {
    private static final long serialVersionUID = 464583892898579544L;

    private static Expression<?> merge(Expression<?> ... args) {
        if (args.length == 1) {
            return args[0];
        }
        return ExpressionUtils.list(Object.class, args);
    }

    public WithinGroup(Class<T> type, Operator<? super T> op) {
        super(type, op, ImmutableList.of());
    }

    public WithinGroup(Class<T> type, Operator<? super T> op, Expression<?> arg) {
        super(type, op, ImmutableList.of(arg));
    }

    public WithinGroup(Class<T> type, Operator<? super T> op, Expression<?> arg1, Expression<?> arg2) {
        super(type, op, ImmutableList.of(arg1, arg2));
    }

    public WithinGroup(Class<T> type, Operator<? super T> op, Expression<?> ... args) {
        super(type, op, new Expression[]{WithinGroup.merge(args)});
    }

    public OrderBy withinGroup() {
        return new OrderBy();
    }

    public class OrderBy
    extends MutableExpressionBase<T> {
        private static final long serialVersionUID = -4936481493030913621L;
        private static final String ORDER_BY = "order by ";
        private volatile SimpleExpression<T> value;
        private final List<OrderSpecifier<?>> orderBy;

        public OrderBy() {
            super(WithinGroup.this.getType());
            this.orderBy = new ArrayList();
        }

        public SimpleExpression<T> getValue() {
            if (this.value == null) {
                int size = 0;
                ImmutableList.Builder args = ImmutableList.builder();
                StringBuilder builder = new StringBuilder();
                builder.append("{0} within group (");
                args.add((Object)WithinGroup.this);
                ++size;
                if (!this.orderBy.isEmpty()) {
                    builder.append(ORDER_BY);
                    boolean first = true;
                    for (OrderSpecifier<?> expr : this.orderBy) {
                        if (!first) {
                            builder.append(", ");
                        }
                        builder.append("{" + size + "}");
                        if (!expr.isAscending()) {
                            builder.append(" desc");
                        }
                        args.add((Object)expr.getTarget());
                        ++size;
                        first = false;
                    }
                }
                builder.append(")");
                this.value = new SimpleTemplate(WithinGroup.this.getType(), TemplateFactory.DEFAULT.create(builder.toString()), args.build());
            }
            return this.value;
        }

        public <R, C> R accept(Visitor<R, C> v, C context) {
            return (R)this.getValue().accept(v, context);
        }

        public OrderBy orderBy(ComparableExpressionBase<?> orderBy) {
            this.value = null;
            this.orderBy.add(orderBy.asc());
            return this;
        }

        public OrderBy orderBy(ComparableExpressionBase<?> ... orderBy) {
            this.value = null;
            for (ComparableExpressionBase<?> e : orderBy) {
                this.orderBy.add(e.asc());
            }
            return this;
        }
    }
}

