/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.spatial;

import oracle.spatial.geometry.JGeometry;
import org.geolatte.geom.DimensionalFlag;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.LineString;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.MultiPoint;
import org.geolatte.geom.MultiPolygon;
import org.geolatte.geom.Point;
import org.geolatte.geom.PointCollection;
import org.geolatte.geom.PointCollectionFactory;
import org.geolatte.geom.PointSequence;
import org.geolatte.geom.PolyHedralSurface;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.crs.CrsId;

public class JGeometryConverter {
    public static JGeometry convert(Geometry geometry) {
        switch (geometry.getGeometryType()) {
            case POINT: {
                return JGeometryConverter.convert((Point)geometry);
            }
            case GEOMETRY_COLLECTION: {
                return JGeometryConverter.convert((GeometryCollection)geometry);
            }
            case LINE_STRING: {
                return JGeometryConverter.convert((LineString)geometry);
            }
            case LINEAR_RING: {
                return JGeometryConverter.convert((LineString)((LinearRing)geometry));
            }
            case POLYGON: {
                return JGeometryConverter.convert((Polygon)geometry);
            }
            case POLYHEDRAL_SURFACE: {
                return JGeometryConverter.convert((PolyHedralSurface)geometry);
            }
            case MULTI_POINT: {
                return JGeometryConverter.convert((MultiPoint)geometry);
            }
            case MULTI_POLYGON: {
                return JGeometryConverter.convert((MultiPolygon)geometry);
            }
            case MULTI_LINE_STRING: {
                return JGeometryConverter.convert((MultiLineString)geometry);
            }
        }
        throw new IllegalArgumentException(geometry.toString());
    }

    private static double[] getPoints(PointCollection points) {
        int dim = points.getCoordinateDimension();
        double[] values = new double[points.size() * dim];
        int offset = 0;
        for (int i = 0; i < points.size(); ++i) {
            values[offset++] = points.getX(i);
            values[offset++] = points.getY(i);
            if (points.is3D()) {
                values[offset++] = points.getZ(i);
            }
            if (!points.isMeasured()) continue;
            values[offset++] = points.getM(i);
        }
        return values;
    }

    private static double[] getCoordinates(Point geometry) {
        double[] value = new double[geometry.getCoordinateDimension()];
        int offset = 0;
        value[offset++] = geometry.getX();
        value[offset++] = geometry.getY();
        if (geometry.is3D()) {
            value[offset++] = geometry.getZ();
        }
        if (geometry.isMeasured()) {
            value[offset++] = geometry.getM();
        }
        return value;
    }

    private static JGeometry convert(Polygon geometry) {
        int srid = geometry.getSRID();
        int dim = geometry.getCoordinateDimension();
        double[] points = JGeometryConverter.getPoints(geometry.getPoints());
        int[] elemInfo = new int[3 + geometry.getNumInteriorRing() * 3];
        int offset = 0;
        int pointOffset = 1;
        elemInfo[offset++] = pointOffset;
        elemInfo[offset++] = 1003;
        elemInfo[offset++] = 1;
        pointOffset += geometry.getExteriorRing().getNumPoints() * dim;
        for (int i = 0; i < geometry.getNumInteriorRing(); ++i) {
            elemInfo[offset++] = pointOffset;
            elemInfo[offset++] = 2003;
            elemInfo[offset++] = 1;
            pointOffset += geometry.getInteriorRingN(i).getNumPoints() * dim;
        }
        int gtype = dim * 1000 + (geometry.isMeasured() ? dim : 0) * 100 + 3;
        return new JGeometry(gtype, srid, elemInfo, points);
    }

    private static JGeometry convert(PolyHedralSurface geometry) {
        throw new UnsupportedOperationException();
    }

    private static JGeometry convert(LineString geometry) {
        int srid = geometry.getSRID();
        int dim = geometry.getCoordinateDimension();
        double[] points = JGeometryConverter.getPoints((PointCollection)geometry.getPoints());
        int[] elemInfo = new int[]{1, 2, 1};
        int gtype = dim * 1000 + (geometry.isMeasured() ? dim : 0) * 100 + 2;
        return new JGeometry(gtype, srid, elemInfo, points);
    }

    private static JGeometry convert(GeometryCollection geometry) {
        throw new UnsupportedOperationException();
    }

    private static JGeometry convert(MultiPoint geometry) {
        int srid = geometry.getSRID();
        int dim = geometry.getCoordinateDimension();
        double[] points = JGeometryConverter.getPoints(geometry.getPoints());
        int[] elemInfo = new int[]{1, 1, geometry.getNumPoints()};
        int gtype = dim * 1000 + (geometry.isMeasured() ? dim : 0) * 100 + 5;
        return new JGeometry(gtype, srid, elemInfo, points);
    }

    private static JGeometry convert(MultiPolygon geometry) {
        throw new UnsupportedOperationException();
    }

    private static JGeometry convert(MultiLineString geometry) {
        int srid = geometry.getSRID();
        int dim = geometry.getCoordinateDimension();
        double[] points = JGeometryConverter.getPoints(geometry.getPoints());
        int[] elemInfo = new int[geometry.getNumGeometries() * 3];
        int offset = 0;
        int pointOffset = 1;
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            elemInfo[offset++] = pointOffset;
            elemInfo[offset++] = 2;
            elemInfo[offset++] = 1;
            pointOffset += geometry.getGeometryN(i).getNumPoints() * dim;
        }
        int gtype = dim * 1000 + (geometry.isMeasured() ? dim : 0) * 100 + 6;
        return new JGeometry(gtype, srid, elemInfo, points);
    }

    private static JGeometry convert(Point geometry) {
        double[] value = JGeometryConverter.getCoordinates(geometry);
        int srid = geometry.getSRID();
        if (geometry.isMeasured()) {
            return JGeometry.createLRSPoint((double[])value, (int)(value.length - 1), (int)srid);
        }
        return JGeometry.createPoint((double[])value, (int)value.length, (int)srid);
    }

    public static Geometry convert(JGeometry geometry) {
        switch (geometry.getType()) {
            case 4: {
                return JGeometryConverter.convertCollection(geometry);
            }
            case 2: {
                return JGeometryConverter.convertCurve(geometry);
            }
            case 6: {
                return JGeometryConverter.convertMultiCurve(geometry);
            }
            case 5: {
                return JGeometryConverter.convertMultiPoint(geometry);
            }
            case 7: {
                return JGeometryConverter.convertMultiPolygon(geometry);
            }
            case 1: {
                return JGeometryConverter.convertPoint(geometry);
            }
            case 3: {
                return JGeometryConverter.convertPolygon(geometry);
            }
        }
        throw new IllegalArgumentException(geometry.toString());
    }

    private static PointSequence getPoints(JGeometry geometry) {
        int dimensions = geometry.getDimensions();
        boolean measured = geometry.isLRSGeometry();
        DimensionalFlag flag = DimensionalFlag.valueOf((dimensions > (measured ? 3 : 2) ? 1 : 0) != 0, (boolean)measured);
        double[] ordinates = geometry.getOrdinatesArray();
        return PointCollectionFactory.create((double[])ordinates, (DimensionalFlag)flag);
    }

    private static Polygon convertPolygon(JGeometry geometry) {
        CrsId crs = CrsId.valueOf((int)geometry.getSRID());
        int dimensions = geometry.getDimensions();
        boolean measured = geometry.isLRSGeometry();
        DimensionalFlag flag = DimensionalFlag.valueOf((dimensions > (measured ? 3 : 2) ? 1 : 0) != 0, (boolean)measured);
        Object[] elements = geometry.getOrdinatesOfElements();
        LinearRing[] rings = new LinearRing[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            PointSequence points = PointCollectionFactory.create((double[])((double[])elements[i]), (DimensionalFlag)flag);
            rings[i] = new LinearRing(points, crs);
        }
        return new Polygon(rings);
    }

    private static Point convertPoint(JGeometry geometry) {
        CrsId crs = CrsId.valueOf((int)geometry.getSRID());
        double[] point = geometry.getPoint();
        int dimensions = geometry.getDimensions();
        boolean measured = geometry.isLRSGeometry();
        DimensionalFlag flag = DimensionalFlag.valueOf((dimensions > (measured ? 3 : 2) ? 1 : 0) != 0, (boolean)measured);
        return new Point(PointCollectionFactory.create((double[])point, (DimensionalFlag)flag), crs);
    }

    private static LineString convertCurve(JGeometry geometry) {
        CrsId crs = CrsId.valueOf((int)geometry.getSRID());
        PointSequence points = JGeometryConverter.getPoints(geometry);
        return new LineString(points, crs);
    }

    private static MultiPoint convertMultiPoint(JGeometry geometry) {
        CrsId crs = CrsId.valueOf((int)geometry.getSRID());
        JGeometry[] elements = geometry.getElements();
        if (elements == null || elements.length == 0) {
            return MultiPoint.createEmpty();
        }
        Point[] points = new Point[elements.length];
        int dimensions = geometry.getDimensions();
        double[] ordinates = geometry.getOrdinatesArray();
        boolean measured = geometry.isLRSGeometry();
        DimensionalFlag flag = DimensionalFlag.valueOf((dimensions > (measured ? 3 : 2) ? 1 : 0) != 0, (boolean)measured);
        int offset = 0;
        for (int i = 0; i < points.length; ++i) {
            double[] coords = new double[dimensions];
            System.arraycopy(ordinates, offset, coords, 0, coords.length);
            points[i] = new Point(PointCollectionFactory.create((double[])coords, (DimensionalFlag)flag), crs);
            offset += dimensions;
        }
        return new MultiPoint(points);
    }

    private static MultiPolygon convertMultiPolygon(JGeometry geometry) {
        JGeometry[] elements = geometry.getElements();
        if (elements == null || elements.length == 0) {
            return MultiPolygon.createEmpty();
        }
        Polygon[] polygons = new Polygon[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            polygons[i] = JGeometryConverter.convertPolygon(elements[i]);
        }
        return new MultiPolygon(polygons);
    }

    private static MultiLineString convertMultiCurve(JGeometry geometry) {
        JGeometry[] elements = geometry.getElements();
        if (elements == null || elements.length == 0) {
            return MultiLineString.createEmpty();
        }
        CrsId crs = CrsId.valueOf((int)geometry.getSRID());
        LineString[] lineStrings = new LineString[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            PointSequence points = JGeometryConverter.getPoints(elements[i]);
            lineStrings[i] = new LineString(points, crs);
        }
        return new MultiLineString(lineStrings);
    }

    private static GeometryCollection convertCollection(JGeometry geometry) {
        JGeometry[] elements = geometry.getElements();
        if (elements == null || elements.length == 0) {
            return GeometryCollection.createEmpty();
        }
        Geometry[] geometries = new Geometry[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            geometries[i] = JGeometryConverter.convert(elements[i]);
        }
        return new GeometryCollection(geometries);
    }

    private JGeometryConverter() {
    }
}

