/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.spatial;

import com.google.common.collect.Lists;
import com.vividsolutions.jts.io.ByteArrayInStream;
import com.vividsolutions.jts.io.ByteOrderDataInStream;
import com.vividsolutions.jts.io.InStream;
import java.io.IOException;
import java.util.ArrayList;
import org.geolatte.geom.DimensionalFlag;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.LineString;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.MultiPoint;
import org.geolatte.geom.MultiPolygon;
import org.geolatte.geom.Point;
import org.geolatte.geom.PointSequence;
import org.geolatte.geom.PointSequenceBuilder;
import org.geolatte.geom.PointSequenceBuilders;
import org.geolatte.geom.Points;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.crs.CrsId;

public class SQLServerGeometryReader {
    private static GeometryType[] TYPES = new GeometryType[]{GeometryType.POINT, GeometryType.LINE_STRING, GeometryType.POLYGON, GeometryType.MULTI_POINT, GeometryType.MULTI_LINE_STRING, GeometryType.MULTI_POLYGON, GeometryType.GEOMETRY_COLLECTION};
    private int srid;
    private int version;
    private int serializationProps;
    private int numberOfPoints;
    private boolean hasZ;
    private boolean hasM;
    private boolean singlePoint;
    private boolean singleLine;
    private DimensionalFlag dimensionalFlag;
    private double[][] points;
    private double[] zValues;
    private double[] mValues;
    private Figure[] figures;
    private Shape[] shapes;
    private CrsId crsId;

    public Geometry read(byte[] bytes) throws IOException {
        return this.read((InStream)new ByteArrayInStream(bytes));
    }

    public Geometry read(InStream is) throws IOException {
        ByteOrderDataInStream dis = new ByteOrderDataInStream(is);
        dis.setOrder(2);
        this.srid = dis.readInt();
        this.version = dis.readByte();
        this.serializationProps = dis.readByte();
        this.hasZ = (this.serializationProps & 1) == 1;
        this.hasM = (this.serializationProps & 2) == 2;
        this.singlePoint = (this.serializationProps & 8) == 8;
        this.singleLine = (this.serializationProps & 0x10) == 16;
        this.numberOfPoints = 1;
        if (this.singleLine) {
            this.numberOfPoints = 2;
        } else if (!this.singlePoint) {
            this.numberOfPoints = dis.readInt();
        }
        this.dimensionalFlag = DimensionalFlag.XY;
        if (this.hasM) {
            this.dimensionalFlag = this.hasZ ? DimensionalFlag.XYZM : DimensionalFlag.XYM;
        } else if (this.hasZ) {
            this.dimensionalFlag = DimensionalFlag.XYZ;
        }
        this.points = this.readPoints(dis, this.numberOfPoints);
        if (this.hasZ) {
            this.zValues = this.readDoubles(dis, this.numberOfPoints);
        }
        if (this.hasM) {
            this.mValues = this.readDoubles(dis, this.numberOfPoints);
        }
        this.crsId = CrsId.valueOf((int)this.srid);
        if (this.singlePoint) {
            return this.createPoint(0);
        }
        if (this.singleLine) {
            PointSequence points = this.createPoints(0, 2);
            return new LineString(points, this.crsId);
        }
        int numberOfFigures = dis.readInt();
        this.figures = this.readFigures(dis, numberOfFigures);
        int numberOfShapes = dis.readInt();
        this.shapes = this.readShapes(dis, numberOfShapes);
        return this.decode(0);
    }

    private Geometry decode(int shapeIdx) {
        switch (this.shapes[shapeIdx].type) {
            case POINT: {
                return this.decodePoint(shapeIdx);
            }
            case LINE_STRING: {
                return this.decodeLineString(shapeIdx);
            }
            case POLYGON: {
                return this.decodePolygon(shapeIdx);
            }
            case MULTI_POINT: {
                return this.decodeMultiPoint(shapeIdx);
            }
            case MULTI_LINE_STRING: {
                return this.decodeMultiLineString(shapeIdx);
            }
            case MULTI_POLYGON: {
                return this.decodeMultiPolygon(shapeIdx);
            }
            case GEOMETRY_COLLECTION: {
                return this.decodeGeometryCollection(shapeIdx);
            }
        }
        throw new IllegalArgumentException(String.valueOf(shapeIdx));
    }

    private GeometryCollection decodeGeometryCollection(int shapeIdx) {
        ArrayList geometries = Lists.newArrayList();
        for (int i = shapeIdx; i < this.shapes.length; ++i) {
            if (this.shapes[i].parentOffset != shapeIdx) continue;
            geometries.add(this.decode(i));
        }
        return new GeometryCollection(geometries.toArray(new Geometry[0]));
    }

    private MultiLineString decodeMultiLineString(int shapeIdx) {
        ArrayList lineStrings = Lists.newArrayList();
        for (int i = shapeIdx; i < this.shapes.length; ++i) {
            if (this.shapes[i].parentOffset != shapeIdx) continue;
            lineStrings.add(this.decodeLineString(i));
        }
        return new MultiLineString(lineStrings.toArray(new LineString[0]));
    }

    private MultiPolygon decodeMultiPolygon(int shapeIdx) {
        ArrayList polygons = Lists.newArrayList();
        for (int i = shapeIdx; i < this.shapes.length; ++i) {
            if (this.shapes[i].parentOffset != shapeIdx) continue;
            polygons.add(this.decodePolygon(i));
        }
        return new MultiPolygon(polygons.toArray(new Polygon[0]));
    }

    private MultiPoint decodeMultiPoint(int shapeIdx) {
        ArrayList points = Lists.newArrayList();
        for (int i = shapeIdx; i < this.shapes.length; ++i) {
            if (this.shapes[i].parentOffset != shapeIdx) continue;
            points.add(this.decodePoint(i));
        }
        return new MultiPoint(points.toArray(new Point[0]));
    }

    private Polygon decodePolygon(int shapeIdx) {
        Shape shape = this.shapes[shapeIdx];
        int figureOffset = shape.figureOffset;
        if (figureOffset <= -1) {
            return Polygon.createEmpty();
        }
        int figureStopIdx = this.figures.length - 1;
        if (shapeIdx < this.shapes.length - 1) {
            figureStopIdx = this.shapes[shapeIdx + 1].figureOffset - 1;
        }
        ArrayList linearRings = Lists.newArrayList();
        for (int i = figureOffset; i <= figureStopIdx; ++i) {
            linearRings.add(new LinearRing(this.createPoints(i), this.crsId));
        }
        return new Polygon(linearRings.toArray(new LinearRing[0]));
    }

    private LineString decodeLineString(int shapeIdx) {
        Shape shape = this.shapes[shapeIdx];
        return new LineString(this.createPoints(shape.figureOffset), this.crsId);
    }

    private Point decodePoint(int shapeIdx) {
        int pointIdx = this.figures[this.shapes[shapeIdx].figureOffset].pointOffset;
        return this.createPoint(pointIdx);
    }

    private Point createPoint(int idx) {
        double x = this.points[idx][0];
        double y = this.points[idx][1];
        if (this.hasM) {
            if (this.hasZ) {
                return Points.create((double)x, (double)y, (double)this.zValues[idx], (double)this.mValues[idx], (CrsId)this.crsId);
            }
            return Points.createMeasured((double)x, (double)y, (double)this.mValues[idx], (CrsId)this.crsId);
        }
        if (this.hasZ) {
            return Points.create3D((double)x, (double)y, (double)this.zValues[idx], (CrsId)this.crsId);
        }
        return Points.create((double)x, (double)y, (CrsId)this.crsId);
    }

    private PointSequence createPoints(int idx1, int idx2) {
        PointSequenceBuilder builder = PointSequenceBuilders.fixedSized((int)(idx2 - idx1), (DimensionalFlag)this.dimensionalFlag);
        for (int i = idx1; i < idx2; ++i) {
            builder.add(this.createPoint(i));
        }
        return builder.toPointSequence();
    }

    private PointSequence createPoints(int figureIdx) {
        int idx1 = this.figures[figureIdx].pointOffset;
        int idx2 = this.points.length;
        if (figureIdx < this.figures.length - 1) {
            idx2 = this.figures[figureIdx + 1].pointOffset;
        }
        return this.createPoints(idx1, idx2);
    }

    private double[] readDoubles(ByteOrderDataInStream is, int num) throws IOException {
        double[] doubles = new double[num];
        for (int i = 0; i < num; ++i) {
            doubles[i] = is.readDouble();
        }
        return doubles;
    }

    private Figure[] readFigures(ByteOrderDataInStream is, int num) throws IOException {
        Figure[] figures = new Figure[num];
        for (int i = 0; i < num; ++i) {
            Figure figure = new Figure();
            figure.attributes = is.readByte();
            figure.pointOffset = is.readInt();
            figures[i] = figure;
        }
        return figures;
    }

    private double[][] readPoints(ByteOrderDataInStream is, int num) throws IOException {
        double[][] points = new double[num][];
        for (int i = 0; i < num; ++i) {
            points[i] = new double[]{is.readDouble(), is.readDouble()};
        }
        return points;
    }

    private Shape[] readShapes(ByteOrderDataInStream is, int num) throws IOException {
        Shape[] shapes = new Shape[num];
        for (int i = 0; i < num; ++i) {
            Shape shape = new Shape();
            shape.parentOffset = is.readInt();
            shape.figureOffset = is.readInt();
            shape.type = TYPES[is.readByte() - 1];
            shapes[i] = shape;
        }
        return shapes;
    }

    private static class Shape {
        int parentOffset;
        int figureOffset;
        GeometryType type;

        private Shape() {
        }
    }

    private static class Figure {
        int attributes;
        int pointOffset;

        private Figure() {
        }
    }
}

