/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.FileCacheDirectoryTree;
import com.swoval.files.FileCachePathWatcher;
import com.swoval.files.FileTreeDataViews;
import com.swoval.files.FileTreeRepository;
import com.swoval.files.FileTreeViews;
import com.swoval.files.TypedPath;
import com.swoval.functional.Either;
import com.swoval.functional.Filter;
import com.swoval.logging.Logger;
import com.swoval.logging.Loggers;
import com.swoval.runtime.ShutdownHooks;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

class FileTreeRepositoryImpl<T>
implements FileTreeRepository<T> {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final FileCacheDirectoryTree<T> directoryTree;
    private final FileCachePathWatcher<T> watcher;
    private final Runnable closeRunnable = new Runnable(){

        @Override
        public void run() {
            if (FileTreeRepositoryImpl.this.closed.compareAndSet(false, true)) {
                ShutdownHooks.removeHook(FileTreeRepositoryImpl.this.shutdownHookId);
                FileTreeRepositoryImpl.this.watcher.close();
                FileTreeRepositoryImpl.this.directoryTree.close();
            }
        }
    };
    private final int shutdownHookId = ShutdownHooks.addHook(1, this.closeRunnable);
    private final Logger logger;

    FileTreeRepositoryImpl(FileCacheDirectoryTree<T> fileCacheDirectoryTree, FileCachePathWatcher<T> fileCachePathWatcher, Logger logger) {
        this.directoryTree = fileCacheDirectoryTree;
        this.watcher = fileCachePathWatcher;
        this.logger = logger;
    }

    FileTreeRepositoryImpl(FileCacheDirectoryTree<T> fileCacheDirectoryTree, FileCachePathWatcher<T> fileCachePathWatcher) {
        this(fileCacheDirectoryTree, fileCachePathWatcher, Loggers.getLogger());
    }

    @Override
    public void close() {
        this.closeRunnable.run();
    }

    @Override
    public int addObserver(final FileTreeViews.Observer<? super FileTreeDataViews.Entry<T>> observer) {
        return this.addCacheObserver(new FileTreeDataViews.CacheObserver<T>(){

            @Override
            public void onCreate(FileTreeDataViews.Entry<T> entry) {
                observer.onNext(entry);
            }

            @Override
            public void onDelete(FileTreeDataViews.Entry<T> entry) {
                observer.onNext(entry);
            }

            @Override
            public void onUpdate(FileTreeDataViews.Entry<T> entry, FileTreeDataViews.Entry<T> entry2) {
                observer.onNext(entry2);
            }

            @Override
            public void onError(IOException iOException) {
                observer.onError(iOException);
            }
        });
    }

    @Override
    public void removeObserver(int n) {
        this.directoryTree.removeObserver(n);
    }

    @Override
    public List<FileTreeDataViews.Entry<T>> listEntries(Path path, int n, Filter<? super FileTreeDataViews.Entry<T>> filter) {
        return this.directoryTree.listEntries(path, n, filter);
    }

    @Override
    public Either<IOException, Boolean> register(Path path, int n) {
        try {
            Path path2 = path.isAbsolute() ? path : path.toAbsolutePath();
            Either<IOException, Boolean> either = Either.right(this.watcher.register(path2, n));
            if (Loggers.shouldLog(this.logger, Loggers.Level.DEBUG)) {
                this.logger.debug(this + " registered " + path + " with max depth " + n);
            }
            if (either.isLeft() && Loggers.shouldLog(this.logger, Loggers.Level.WARN)) {
                this.logger.warn(this + " failed to register " + path + " for monitoring");
            }
            return either;
        }
        catch (IOException iOException) {
            return Either.left(iOException);
        }
    }

    @Override
    public void unregister(Path path) {
        Path path2 = path.isAbsolute() ? path : path.toAbsolutePath();
        this.watcher.unregister(path2);
    }

    @Override
    public List<TypedPath> list(Path path, int n, Filter<? super TypedPath> filter) {
        return this.directoryTree.list(path, n, filter);
    }

    @Override
    public int addCacheObserver(FileTreeDataViews.CacheObserver<T> cacheObserver) {
        return this.directoryTree.addCacheObserver(cacheObserver);
    }

    static abstract class Callback
    implements Runnable,
    Comparable<Callback> {
        private final Path path;

        Callback(Path path) {
            this.path = path;
        }

        @Override
        public int compareTo(Callback callback) {
            return this.path.compareTo(callback.path);
        }
    }
}

