/*
 * Decompiled with CFR 0.152.
 */
package com.vectorc.mule.rdf.jena;

import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.vectorc.mule.rdf.jena.ConnectorListener;
import com.vectorc.mule.rdf.jena.SQLExceptionReader;
import com.vectorc.mule.rdf.jena.util.JenaQueryHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.config.ExceptionReader;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageReceiver;
import org.mule.config.ExceptionHelper;
import org.mule.transport.AbstractConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJenaConnector
extends AbstractConnector {
    public static final String JENA = "jena";
    public static final String PROPERTY_POLLING_FREQUENCY = "pollingFrequency";
    public static final long DEFAULT_POLLING_FREQUENCY = 1000L;
    protected long pollingFrequency = 0L;
    protected Map<String, JenaQueryHelper> mapQueries;
    protected ConnectorListener listener = null;

    public AbstractJenaConnector(MuleContext context) {
        super(context);
    }

    public MessageReceiver createReceiver(Service service, InboundEndpoint endpoint) throws Exception {
        String tempPolling;
        Map props = endpoint.getProperties();
        if (props != null && (tempPolling = (String)props.get(PROPERTY_POLLING_FREQUENCY)) != null) {
            this.pollingFrequency = Long.parseLong(tempPolling);
        }
        if (this.getPollingFrequency() <= 0L) {
            this.pollingFrequency = 1000L;
        }
        JenaQueryHelper query = this.getReadQuery((ImmutableEndpoint)endpoint, null);
        return this.getServiceDescriptor().createMessageReceiver((Connector)this, (FlowConstruct)service, endpoint, (Object[])new JenaQueryHelper[]{query});
    }

    public JenaQueryHelper getReadQuery(ImmutableEndpoint endpoint, Object message) {
        JenaQueryHelper helper = null;
        String queryPropertyValue = (String)endpoint.getProperty((Object)"sparql");
        if (queryPropertyValue != null) {
            try {
                helper = new JenaQueryHelper(Syntax.syntaxSPARQL);
                helper.setQueryString(queryPropertyValue);
            }
            catch (QueryException ex) {
                throw new IllegalArgumentException("SPARQL query parse error: " + ex.getMessage());
            }
        } else {
            String queryString;
            String key = endpoint.getEndpointURI().getAddress();
            if (this.mapQueries != null) {
                helper = this.mapQueries.get(key);
            }
            if (helper == null && message != null && (queryString = JenaQueryHelper.getPropertyFromHeaderOrPayload("sparql", message)) != null) {
                helper = new JenaQueryHelper(Syntax.syntaxSPARQL);
                helper.setQueryString(queryString);
            }
        }
        if (helper == null) {
            throw new IllegalArgumentException("Connector does not have a bound SPARQL query");
        }
        if (!(helper.getJenaQuery().isAskType() || helper.getJenaQuery().isConstructType() || helper.getJenaQuery().isSelectType() || helper.getJenaQuery().isDescribeType())) {
            throw new IllegalArgumentException("SPARQL read statement should be an ask, construct, describe or select");
        }
        return helper;
    }

    public List getEndpointQueryBindings(ImmutableEndpoint endpoint) {
        List endpointBindings = null;
        if (endpoint != null && endpoint.getProperties() != null) {
            endpointBindings = (List)endpoint.getProperties().get("bindings");
        }
        return endpointBindings;
    }

    public abstract MuleMessage executeRead(long var1, MuleEvent var3, ImmutableEndpoint var4) throws Exception;

    public abstract Object executeRead(JenaQueryHelper var1, ImmutableEndpoint var2) throws Exception;

    public abstract void executeLoad(String var1, ImmutableEndpoint var2) throws Exception;

    public abstract void executeInsert(Model var1, ImmutableEndpoint var2) throws Exception;

    public abstract void executeDelete(Model var1, ImmutableEndpoint var2) throws Exception;

    public abstract void executeClear(ImmutableEndpoint var1) throws Exception;

    public abstract long size() throws Exception;

    protected void doDispose() {
    }

    protected void doInitialise() throws InitialisationException {
    }

    protected void doConnect() throws Exception {
        this.logger.debug((Object)("AbstractJenaConnector " + this.getName() + " doConnect()"));
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }

    public String getProtocol() {
        return JENA;
    }

    public long getPollingFrequency() {
        return this.pollingFrequency;
    }

    public void setPollingFrequency(long pollingFrequency) {
        this.pollingFrequency = pollingFrequency;
    }

    public void setConnectorListener(ConnectorListener listener) {
        this.listener = listener;
    }

    public ConnectorListener getConnectorListener() {
        return this.listener;
    }

    protected void updateListener() {
        if (this.listener != null) {
            this.listener.repositoryUpdated();
        }
    }

    public List<QueryMapEntry> getQueries() {
        if (this.mapQueries == null) {
            return null;
        }
        ArrayList<QueryMapEntry> result = new ArrayList<QueryMapEntry>();
        for (Map.Entry<String, JenaQueryHelper> entry : this.mapQueries.entrySet()) {
            result.add(new QueryMapEntry(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    public void setQueries(List<QueryMapEntry> queries) {
        this.mapQueries = new HashMap<String, JenaQueryHelper>();
        for (int i = 0; i < queries.size(); ++i) {
            QueryMapEntry entry = queries.get(i);
            this.mapQueries.put(entry.getKey(), entry.getQueryHelper());
        }
    }

    static {
        ExceptionHelper.registerExceptionReader((ExceptionReader)new SQLExceptionReader());
    }

    public static class QueryMapEntry {
        private JenaQueryHelper queryHelper;
        private String key;

        public QueryMapEntry() {
        }

        protected QueryMapEntry(String key, JenaQueryHelper queryHelper) {
            this.key = key;
            this.queryHelper = queryHelper;
        }

        public JenaQueryHelper getQueryHelper() {
            return this.queryHelper;
        }

        public void setQueryHelper(JenaQueryHelper queryHelper) {
            this.queryHelper = queryHelper;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }
    }
}

