/*
 * Decompiled with CFR 0.152.
 */
package com.vectorc.mule.rdf.jena;

import com.vectorc.mule.rdf.jena.AbstractJenaModelConnector;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.config.i18n.MessageFactory;
import org.mule.transaction.TransactionCoordination;

public abstract class AbstractJenaDBConnector
extends AbstractJenaModelConnector {
    private static final Log logger = LogFactory.getLog(AbstractJenaDBConnector.class);
    private String dbType;
    private DataSource dataSource;

    public AbstractJenaDBConnector(MuleContext context) {
        super(context);
    }

    public abstract DBConnectionWrapper createFromJdbcConnection(Connection var1);

    protected void doInitialise() throws InitialisationException {
        if (this.dataSource == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage((String)"Missing data source"), (Initialisable)this);
        }
    }

    public AbstractJenaModelConnector.ConnectionWrapper createConnection() throws Exception {
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        if (tx != null && tx.hasResource((Object)this.getDataSource())) {
            logger.debug((Object)"Retrieving connection from current transaction");
            return (AbstractJenaModelConnector.ConnectionWrapper)tx.getResource((Object)this.getDataSource());
        }
        logger.debug((Object)"Retrieving new connection from data source");
        Connection jdbcCon = this.getDataSource().getConnection();
        DBConnectionWrapper wrapper = this.createFromJdbcConnection(jdbcCon);
        if (tx != null) {
            logger.debug((Object)"Binding connection to current transaction");
            try {
                tx.bindResource((Object)this.getDataSource(), (Object)wrapper);
            }
            catch (TransactionException e) {
                wrapper.close();
                throw new RuntimeException("Could not bind connection to current transaction", e);
            }
        }
        return wrapper;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public static abstract class DBConnectionWrapper
    implements AbstractJenaModelConnector.ConnectionWrapper {
        public abstract Connection getConnection() throws SQLException;

        public boolean isOpen() {
            try {
                return this.getConnection() != null && !this.getConnection().isClosed();
            }
            catch (SQLException e) {
                return false;
            }
        }
    }
}

