/*
 * Decompiled with CFR 0.152.
 */
package com.vectorc.mule.rdf.jena;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.vectorc.mule.rdf.jena.AbstractJenaConnector;
import com.vectorc.mule.rdf.jena.JenaUpdateMessageDispatcher;
import com.vectorc.mule.rdf.jena.util.JenaQueryHelper;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.transport.Connectable;
import org.mule.transport.ConnectException;

public abstract class AbstractJenaModelConnector
extends AbstractJenaConnector {
    private static final Log logger = LogFactory.getLog(AbstractJenaModelConnector.class);
    protected ConnectionWrapper conn = null;

    public AbstractJenaModelConnector(MuleContext context) {
        super(context);
    }

    public long size() throws Exception {
        return this.getConnection().getReadModel().size();
    }

    public void doStop() throws MuleException {
        if (this.conn != null) {
            logger.debug((Object)("Closing connector " + this.getName() + " on stop"));
            try {
                this.conn.close();
            }
            catch (Exception e) {
                throw new DefaultMuleException((Throwable)e);
            }
        }
    }

    public abstract ConnectionWrapper createConnection() throws Exception;

    public synchronized ConnectionWrapper getConnection() throws Exception {
        if (this.conn == null || !this.conn.isOpen()) {
            logger.debug((Object)"Need to create new Jena Model connection");
            this.conn = this.createConnection();
            return this.conn;
        }
        logger.debug((Object)"Returning existing Jena Model connection");
        return this.conn;
    }

    protected void cleanupConnection(ConnectionWrapper wrapper) throws Exception {
    }

    public MuleMessage executeRead(long timeout, MuleEvent event, ImmutableEndpoint endpoint) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Perform read with a timeout of " + timeout));
        }
        JenaQueryHelper query = this.getReadQuery(endpoint, event == null ? null : event.getMessage());
        long t0 = System.currentTimeMillis();
        ConnectionWrapper wrapper = null;
        try {
            MuleMessage message;
            Object result;
            wrapper = this.getConnection();
            Model model = wrapper.getReadModel();
            if (timeout < 0L) {
                timeout = Long.MAX_VALUE;
            }
            while (true) {
                if ((result = this.executeQuery(model, query, endpoint, event != null ? event.getMessage() : null)) == Boolean.FALSE) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"False ASK result, ignorning");
                    }
                    result = null;
                }
                if (result != null) {
                    if (!logger.isDebugEnabled()) break;
                    logger.debug((Object)("Received: " + result));
                    break;
                }
                long sleep = Math.min(this.getPollingFrequency(), timeout - (System.currentTimeMillis() - t0));
                if (sleep > 0L) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("No results, sleeping for " + sleep));
                    }
                } else {
                    logger.debug((Object)"Timeout");
                    MuleMessage muleMessage = null;
                    return muleMessage;
                }
                Thread.sleep(sleep);
            }
            MuleMessage muleMessage = message = this.getMuleMessageFactory().create(result, this.getMuleContext().getConfiguration().getDefaultEncoding());
            return muleMessage;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (wrapper != null) {
                this.cleanupConnection(wrapper);
            }
        }
    }

    protected Object executeQuery(Model model, JenaQueryHelper query, ImmutableEndpoint endpoint, Object message) throws Exception {
        List endpointBindings = this.getEndpointQueryBindings(endpoint);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(model.size() + " triples in model prior to executing query"));
        }
        return query.execute(model, endpointBindings, message);
    }

    public Object executeRead(JenaQueryHelper query, ImmutableEndpoint endpoint) throws Exception {
        ConnectionWrapper wrapper = null;
        try {
            wrapper = this.getConnection();
            Model model = wrapper.getReadModel();
            Object object = this.executeQuery(model, query, endpoint, null);
            return object;
        }
        catch (Exception e) {
            throw new ConnectException((Throwable)e, (Connectable)this);
        }
        finally {
            if (wrapper != null) {
                this.cleanupConnection(wrapper);
            }
        }
    }

    public void executeLoad(String url, ImmutableEndpoint endpoint) throws Exception {
        this.executeUpdate(JenaUpdateMessageDispatcher.UpdateAction.load, url, endpoint);
    }

    public void executeInsert(Model inputModel, ImmutableEndpoint endpoint) throws Exception {
        this.executeUpdate(JenaUpdateMessageDispatcher.UpdateAction.insert, inputModel, endpoint);
    }

    public void executeDelete(Model inputModel, ImmutableEndpoint endpoint) throws Exception {
        this.executeUpdate(JenaUpdateMessageDispatcher.UpdateAction.delete, inputModel, endpoint);
    }

    public void executeClear(ImmutableEndpoint endpoint) throws Exception {
        this.executeUpdate(JenaUpdateMessageDispatcher.UpdateAction.clear, null, endpoint);
    }

    protected boolean supportsTransactions(Model model) {
        return model.supportsTransactions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeUpdate(JenaUpdateMessageDispatcher.UpdateAction action, Object input, ImmutableEndpoint endpoint) throws Exception {
        ConnectionWrapper wrapper = null;
        try {
            wrapper = this.getConnection();
            Model targetModel = wrapper.getUpdateModel();
            try {
                targetModel.enterCriticalSection(false);
                if (this.supportsTransactions(targetModel)) {
                    logger.debug((Object)"Starting the transaction");
                    targetModel.begin();
                }
                if (action == JenaUpdateMessageDispatcher.UpdateAction.insert) {
                    Model inputModel = (Model)input;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Adding " + inputModel.size() + " triples to model of size: " + targetModel.size()));
                    }
                    this.addToModel(targetModel, inputModel);
                    this.updateListener();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Triples after add: " + wrapper.getUpdateModel().size()));
                    }
                } else if (action == JenaUpdateMessageDispatcher.UpdateAction.load) {
                    String url = (String)input;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Loading RDF from " + url + " into model of size " + targetModel.size()));
                    }
                    this.loadIntoModel(targetModel, url);
                    this.updateListener();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Triples after load: " + wrapper.getUpdateModel().size()));
                    }
                } else if (action == JenaUpdateMessageDispatcher.UpdateAction.delete) {
                    Model inputModel = (Model)input;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Deleting" + inputModel.size() + " triples from model of size " + targetModel.size()));
                    }
                    this.deleteFromModel(targetModel, inputModel);
                    this.updateListener();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Triples after delete: " + wrapper.getUpdateModel().size()));
                    }
                } else if (action == JenaUpdateMessageDispatcher.UpdateAction.clear) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Clearing all triples from model of size: " + targetModel.size()));
                    }
                    this.clearModel(targetModel);
                    this.updateListener();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Triples after clear: " + targetModel.size()));
                    }
                }
                if (!targetModel.isClosed() && this.supportsTransactions(targetModel)) {
                    logger.debug((Object)"Committing the transaction");
                    targetModel.commit();
                }
            }
            catch (Exception e) {
                if (this.supportsTransactions(targetModel)) {
                    logger.debug((Object)"Rolling back the transaction", (Throwable)e);
                    targetModel.abort();
                }
                throw e;
            }
            finally {
                targetModel.leaveCriticalSection();
            }
        }
        finally {
            if (wrapper != null) {
                this.cleanupConnection(wrapper);
            }
        }
    }

    protected void addToModel(Model targetModel, Model inputModel) throws Exception {
        targetModel.add(inputModel);
    }

    protected void loadIntoModel(Model targetModel, String url) throws Exception {
        RDFReader reader = targetModel.getReader();
        reader.setProperty("WARN_REDEFINITION_OF_ID", (Object)"EM_IGNORE");
        targetModel.read(url);
    }

    protected void deleteFromModel(Model targetModel, Model inputModel) throws Exception {
        List stmts = inputModel.listStatements().toList();
        targetModel.remove(stmts);
    }

    protected void clearModel(Model targetModel) throws Exception {
        targetModel.removeAll();
    }

    public static interface ConnectionWrapper {
        public Model getReadModel();

        public Model getUpdateModel();

        public boolean isOpen();

        public void close() throws Exception;
    }
}

