/*
 * Decompiled with CFR 0.152.
 */
package com.vectorc.mule.rdf.jena;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.vectorc.mule.rdf.jena.AbstractJenaModelConnector;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.util.FileUtils;

public class JenaFileConnector
extends AbstractJenaModelConnector {
    private static final String MODEL_NAME = "ssb.nt";
    private static final Log logger = LogFactory.getLog(JenaFileConnector.class);
    private String path;
    private boolean loadOnStart = false;
    private boolean incrementalSave = true;
    private File file;

    public JenaFileConnector(MuleContext context) {
        super(context);
    }

    protected void doConnect() throws InitialisationException {
        logger.debug((Object)"JenaFileConnector.doConnect()");
        this.file = new File(this.path);
        if (!this.file.isAbsolute()) {
            try {
                String absPath = System.getProperty("java.io.tmpdir") + File.separator + this.path;
                logger.debug((Object)("A non-absolute path \"" + this.path + "\" was specified, creating repository directory under temp dir: " + absPath));
                this.file = FileUtils.newFile((String)absPath).getCanonicalFile();
                this.file.mkdirs();
                if (this.loadOnStart) {
                    logger.debug((Object)"Loading file-based model...");
                    this.getConnection();
                    logger.debug((Object)"...file-based model loaded");
                }
            }
            catch (Exception e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    public synchronized AbstractJenaModelConnector.ConnectionWrapper createConnection() throws Exception {
        return new FileConnectionWrapper(this.file.getCanonicalPath());
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean getLoadOnStart() {
        return this.loadOnStart;
    }

    public void setLoadOnStart(boolean loadOnStart) {
        this.loadOnStart = loadOnStart;
    }

    public boolean getIncrementalSave() {
        return this.incrementalSave;
    }

    public void setIncrementalSave(boolean incrementalSave) {
        this.incrementalSave = incrementalSave;
    }

    protected boolean supportsTransactions(Model model) {
        if (this.incrementalSave) {
            return super.supportsTransactions(model);
        }
        return false;
    }

    public static class FileConnectionWrapper
    implements AbstractJenaModelConnector.ConnectionWrapper {
        private Model model;

        public FileConnectionWrapper(String path) {
            logger.debug((Object)("Creating FileConnector for path: " + path));
            this.model = ModelFactory.createFileModelMaker((String)path, (ReificationStyle)ReificationStyle.Minimal).openModel(JenaFileConnector.MODEL_NAME, false);
        }

        public Model getReadModel() {
            return this.model;
        }

        public Model getUpdateModel() {
            return this.model;
        }

        public boolean isOpen() {
            return !this.model.isClosed();
        }

        public void closeModel() throws Exception {
            if (this.model != null && !this.model.isClosed()) {
                this.model.close();
            }
        }

        public void close() throws Exception {
            this.closeModel();
        }
    }
}

