/*
 * Decompiled with CFR 0.152.
 */
package com.vectorc.mule.rdf.jena;

import com.hp.hpl.jena.rdf.model.Model;
import com.vectorc.mule.rdf.jena.AbstractJenaConnector;
import com.vectorc.mule.rdf.jena.util.JenaQueryHelper;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transport.Connector;
import org.mule.api.transport.ConnectorException;
import org.mule.config.i18n.MessageFactory;

public class JenaHttpConnector
extends AbstractJenaConnector {
    private static final Log logger = LogFactory.getLog(JenaHttpConnector.class);
    private String url;

    public JenaHttpConnector(MuleContext context) {
        super(context);
    }

    protected void doInitialise() throws InitialisationException {
        logger.info((Object)"doInitialize()");
    }

    public long size() throws Exception {
        throw new ConnectorException(MessageFactory.createStaticMessage((String)"JenaHTTPConnector does not support size()"), (Connector)this);
    }

    public Object executeRead(JenaQueryHelper query, ImmutableEndpoint endpoint) throws Exception {
        logger.info((Object)"executeRead called");
        List endpointBindings = this.getEndpointQueryBindings(endpoint);
        Object queryResult = query.execute(this.url, endpointBindings, null);
        return queryResult;
    }

    public MuleMessage executeRead(long timeout, MuleEvent event, ImmutableEndpoint endpoint) throws Exception {
        Object result;
        block6: {
            logger.info((Object)"executeRead called");
            List endpointBindings = this.getEndpointQueryBindings(endpoint);
            JenaQueryHelper query = this.getReadQuery(endpoint, event.getMessage());
            long t0 = System.currentTimeMillis();
            if (timeout < 0L) {
                timeout = Long.MAX_VALUE;
            }
            while (true) {
                if ((result = query.execute(this.url, endpointBindings, (Object)event.getMessage())) == Boolean.FALSE) {
                    result = null;
                }
                if (result != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Received: " + result));
                    }
                    break block6;
                }
                long sleep = Math.min(this.getPollingFrequency(), timeout - (System.currentTimeMillis() - t0));
                if (sleep <= 0L) break;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("No results, sleeping for " + sleep));
                }
                Thread.sleep(sleep);
            }
            logger.debug((Object)"Timeout");
            return null;
        }
        MuleMessage message = this.getMuleMessageFactory().create(result, this.getMuleContext().getConfiguration().getDefaultEncoding());
        return message;
    }

    public void executeInsert(Model model, ImmutableEndpoint endpoint) throws Exception {
        throw new ConnectorException(MessageFactory.createStaticMessage((String)"JenaHTTPConnector does not support INSERT"), (Connector)this);
    }

    public void executeLoad(String url, ImmutableEndpoint endpoint) throws Exception {
        throw new ConnectorException(MessageFactory.createStaticMessage((String)"JenaHTTPConnector does not support LOAD"), (Connector)this);
    }

    public void executeDelete(Model model, ImmutableEndpoint endpoint) throws Exception {
        throw new ConnectorException(MessageFactory.createStaticMessage((String)"JenaHTTPConnector does not support INSERT"), (Connector)this);
    }

    public void executeClear(ImmutableEndpoint endpoint) throws Exception {
        throw new ConnectorException(MessageFactory.createStaticMessage((String)"JenaHTTPConnector does not support CLEAR"), (Connector)this);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

