/*
 * Decompiled with CFR 0.152.
 */
package com.vectorc.mule.rdf.jena;

import com.hp.hpl.jena.query.ResultSet;
import com.vectorc.mule.rdf.jena.AbstractJenaConnector;
import com.vectorc.mule.rdf.jena.util.JenaQueryHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.service.Service;
import org.mule.api.transaction.Transaction;
import org.mule.api.transport.Connector;
import org.mule.transaction.TransactionCoordination;
import org.mule.transport.ConnectException;
import org.mule.transport.TransactedPollingMessageReceiver;

public class JenaMessageReceiver
extends TransactedPollingMessageReceiver {
    private static final Log logger = LogFactory.getLog(JenaMessageReceiver.class);
    protected AbstractJenaConnector connector;
    protected JenaQueryHelper query;

    public JenaMessageReceiver(Connector connector, Service service, InboundEndpoint endpoint) throws CreateException {
        super(connector, (FlowConstruct)service, endpoint);
        logger.info((Object)"Created JenaMessageReceiver");
        this.setFrequency(((AbstractJenaConnector)connector).getPollingFrequency());
        this.setReceiveMessagesInTransaction(false);
        this.connector = (AbstractJenaConnector)connector;
        this.query = ((AbstractJenaConnector)connector).getReadQuery((ImmutableEndpoint)endpoint, null);
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws ConnectException {
    }

    public void processMessage(Object message) throws Exception {
        logger.info((Object)("processsMessage(): " + message));
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        try {
            MuleMessage umoMessage = this.connector.getMuleMessageFactory().create(message, this.connector.getMuleContext().getConfiguration().getDefaultEncoding());
            this.routeMessage(umoMessage, tx);
        }
        catch (Exception ex) {
            if (tx != null) {
                tx.setRollbackOnly();
            }
            throw ex;
        }
        finally {
            if (this.endpoint.getMuleContext().getTransactionManager() != null || tx == null) {
                // empty if block
            }
        }
    }

    public List getMessages() throws Exception {
        logger.info((Object)"getMessages()");
        Object queryResult = this.connector.executeRead(this.query, this.endpoint);
        if (queryResult == null) {
            return null;
        }
        if (queryResult == Boolean.FALSE) {
            return null;
        }
        ArrayList<Object> retList = new ArrayList<Object>();
        if (queryResult instanceof ResultSet) {
            ResultSet result = (ResultSet)queryResult;
            while (result.hasNext()) {
                retList.add(result.nextSolution());
            }
            return retList;
        }
        retList.add(queryResult);
        return retList;
    }
}

