/*
 * Decompiled with CFR 0.152.
 */
package com.vectorc.mule.rdf.jena;

import com.hp.hpl.jena.db.DBConnection;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.vectorc.mule.rdf.jena.AbstractJenaDBConnector;
import java.sql.Connection;
import java.sql.SQLException;
import org.mule.api.MuleContext;

public class JenaRDBConnector
extends AbstractJenaDBConnector {
    public JenaRDBConnector(MuleContext context) {
        super(context);
    }

    public AbstractJenaDBConnector.DBConnectionWrapper createFromJdbcConnection(Connection jdbcConn) {
        return new RDBConnectionWrapper(new DBConnection(jdbcConn, this.getDbType()));
    }

    public static class RDBConnectionWrapper
    extends AbstractJenaDBConnector.DBConnectionWrapper {
        private DBConnection dbConn;
        private Model model;

        public RDBConnectionWrapper(DBConnection dbConn) {
            this.dbConn = dbConn;
            ModelMaker maker = ModelFactory.createModelRDBMaker((IDBConnection)this.dbConn, (ReificationStyle)ReificationStyle.Minimal);
            this.model = maker.createDefaultModel();
        }

        public DBConnection getDBConnection() {
            return this.dbConn;
        }

        public Connection getConnection() throws SQLException {
            return this.dbConn.getConnection();
        }

        public Model getReadModel() {
            return this.model;
        }

        public Model getUpdateModel() {
            return this.model;
        }

        public void close() throws SQLException {
            if (this.isOpen()) {
                this.dbConn.close();
            }
        }
    }
}

