/*
 * Decompiled with CFR 0.152.
 */
package com.vectorc.mule.rdf.jena;

import com.hp.hpl.jena.db.DBConnection;
import com.vectorc.mule.rdf.jena.i18n.JenaMessages;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.mule.api.MuleContext;
import org.mule.api.transaction.TransactionException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transaction.AbstractSingleResourceTransaction;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transaction.TransactionRollbackException;

public class JenaTransaction
extends AbstractSingleResourceTransaction {
    public JenaTransaction(MuleContext context) {
        super(context);
    }

    public void bindResource(Object key, Object resource) throws TransactionException {
        if (!(key instanceof DataSource) || !(resource instanceof DBConnection)) {
            throw new IllegalTransactionStateException(CoreMessages.transactionCanOnlyBindToResources((String)"javax.sql.DataSource/com.hp.hpl.jena.db.DBConnection"));
        }
        try {
            Connection con = ((DBConnection)resource).getConnection();
            if (con.getAutoCommit()) {
                con.setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            throw new TransactionException(JenaMessages.transactionSetAutoCommitFailed(), (Throwable)e);
        }
        super.bindResource(key, resource);
    }

    protected void doBegin() throws TransactionException {
    }

    protected void doCommit() throws TransactionException {
        try {
            Connection con = ((DBConnection)this.resource).getConnection();
            con.commit();
            con.close();
        }
        catch (SQLException e) {
            throw new TransactionException(CoreMessages.transactionCommitFailed(), (Throwable)e);
        }
    }

    protected void doRollback() throws TransactionException {
        try {
            Connection con = ((DBConnection)this.resource).getConnection();
            con.rollback();
            con.close();
        }
        catch (SQLException e) {
            throw new TransactionRollbackException(CoreMessages.transactionRollbackFailed(), (Throwable)e);
        }
    }
}

