/*
 * Decompiled with CFR 0.152.
 */
package com.vectorc.mule.rdf.jena;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.util.FileManager;
import com.vectorc.mule.rdf.jena.AbstractJenaModelConnector;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JenaURLConnector
extends AbstractJenaModelConnector {
    private static final Log logger = LogFactory.getLog(JenaURLConnector.class);
    private List<UrlEntry> urls;

    public JenaURLConnector(MuleContext context) {
        super(context);
    }

    @Override
    protected void doConnect() throws InitialisationException {
        logger.debug((Object)"JenaURLConnector.doConnect()");
        try {
            logger.debug((Object)"Loading models...");
            this.getConnection();
            logger.debug((Object)"...URL-based models loaded");
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    @Override
    public synchronized AbstractJenaModelConnector.ConnectionWrapper createConnection() throws Exception {
        return new URLConnectionWrapper(this.urls);
    }

    public List<UrlEntry> getLocations() {
        return this.urls;
    }

    public void setLocations(List<UrlEntry> urls) {
        this.urls = urls;
    }

    public static class UrlEntry {
        private String url;

        public UrlEntry() {
        }

        protected UrlEntry(String url) {
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String toString() {
            return this.url;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class URLConnectionWrapper
    implements AbstractJenaModelConnector.ConnectionWrapper {
        private Model model = null;

        public URLConnectionWrapper(List<UrlEntry> urls) {
            for (UrlEntry url : urls) {
                logger.info((Object)("Loading RDF at: " + url));
                if (this.model == null) {
                    this.model = FileManager.get().loadModel(url.getUrl());
                } else {
                    this.model.add(FileManager.get().loadModel(url.getUrl()), true);
                }
                logger.info((Object)("Finished loading RDF at: " + url));
            }
        }

        @Override
        public Model getReadModel() {
            return this.model;
        }

        @Override
        public Model getUpdateModel() {
            return null;
        }

        @Override
        public boolean isOpen() {
            return !this.model.isClosed();
        }

        public void closeModel() throws Exception {
            if (this.model != null && !this.model.isClosed()) {
                this.model.close();
            }
        }

        @Override
        public void close() throws Exception {
            this.closeModel();
        }
    }
}

