/*
 * Decompiled with CFR 0.152.
 */
package com.vectorc.mule.rdf.jena;

import com.hp.hpl.jena.rdf.model.Model;
import com.vectorc.mule.rdf.jena.AbstractJenaConnector;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transport.MessageTypeNotSupportedException;
import org.mule.transport.AbstractMessageDispatcher;

public class JenaUpdateMessageDispatcher
extends AbstractMessageDispatcher {
    public static String UPDATE_ACTION = "updateAction";
    public static String LOAD = "LOAD";
    public static String INSERT = "INSERT";
    public static String DELETE = "DELETE";
    public static String CLEAR = "CLEAR";
    private AbstractJenaConnector connector;
    private String updateAction = INSERT;

    public JenaUpdateMessageDispatcher(OutboundEndpoint endpoint, String updateAction) {
        super(endpoint);
        this.updateAction = updateAction;
        this.connector = (AbstractJenaConnector)endpoint.getConnector();
    }

    protected void doDispose() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doDispatch(MuleEvent event) throws Exception {
        Object payload = event.getMessage().getPayload();
        if (this.updateAction.equals(INSERT)) {
            if (!(payload instanceof Model)) throw new MessageTypeNotSupportedException(payload, Model.class);
            Model model = (Model)payload;
            this.connector.executeInsert(model, this.endpoint);
            return;
        } else if (this.updateAction.equals(LOAD)) {
            if (!(payload instanceof String)) throw new MessageTypeNotSupportedException(payload, Model.class);
            String string = (String)payload;
            this.connector.executeLoad(string, this.endpoint);
            return;
        } else if (this.updateAction.equals(DELETE)) {
            if (!(payload instanceof Model)) throw new MessageTypeNotSupportedException(payload, Model.class);
            Model model = (Model)payload;
            this.connector.executeDelete(model, this.endpoint);
            return;
        } else {
            if (!this.updateAction.equals(CLEAR)) return;
            this.connector.executeClear(this.endpoint);
        }
    }

    protected MuleMessage doSend(MuleEvent event) throws Exception {
        this.doDispatch(event);
        return event.getMessage();
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UpdateAction {
        insert,
        load,
        delete,
        clear;

    }
}

