/*
 * Decompiled with CFR 0.152.
 */
package com.vectorc.mule.rdf.jena.common;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.vectorc.mule.rdf.jena.common.RDFData;
import com.vectorc.mule.rdf.jena.common.ReasonerConfig;
import com.vectorc.mule.rdf.jena.i18n.JenaMessages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IncrementalJenaReasoner {
    private static final Log logger = LogFactory.getLog(IncrementalJenaReasoner.class);
    private static final Object REASONER_INIT = new Object();
    private String name;
    private String reasonerType;
    private RDFData rdfData;
    private Reasoner reasoner;

    public IncrementalJenaReasoner() {
    }

    public IncrementalJenaReasoner(RDFData rdfData, String reasonerType) {
        this.setReasonerType(reasonerType);
        this.setRdfData(rdfData);
    }

    protected ReasonerFactory getReasonerFactory(String reasonerType) {
        return ReasonerConfig.getReasonerFactory(reasonerType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeReasoner() throws ReasonerException {
        if (this.reasoner != null) {
            return;
        }
        Object object = REASONER_INIT;
        synchronized (object) {
            OntModel ontModel;
            Reasoner tempReasoner;
            if (this.reasoner != null) {
                return;
            }
            if (this.getRdfData().getModel() instanceof OntModel && (tempReasoner = (ontModel = (OntModel)this.getRdfData().getModel()).getSpecification().getReasoner()) != null) {
                this.reasoner = tempReasoner.bindSchema((Model)ontModel);
                return;
            }
            if (this.reasonerType == null) {
                if (logger != null) {
                    logger.debug((Object)"No reasoner type specified, creating Jena simple RDFS reasoner");
                }
                tempReasoner = ReasonerRegistry.getRDFSSimpleReasoner();
            } else {
                ReasonerFactory factory;
                if (logger != null) {
                    logger.debug((Object)("Creating reasoner for type: " + this.reasonerType));
                }
                if ((factory = this.getReasonerFactory(this.reasonerType)) == null) {
                    throw new ReasonerException(JenaMessages.invalidReasonerType(this.reasonerType).getMessage());
                }
                tempReasoner = factory.create(null);
            }
            this.reasoner = tempReasoner.bindSchema(this.rdfData.getModel());
        }
    }

    public InfModel executeReasoner(Model model) throws ReasonerException {
        this.initializeReasoner();
        return ModelFactory.createInfModel((Reasoner)this.reasoner, (Model)model);
    }

    public boolean validate(Model model) throws ReasonerException {
        InfModel infModel = this.executeReasoner(model);
        ValidityReport validity = infModel.validate();
        return validity.isValid();
    }

    public void setRdfData(RDFData rdfData) {
        this.rdfData = rdfData;
    }

    public RDFData getRdfData() {
        return this.rdfData;
    }

    public void setReasonerType(String reasoner) {
        this.reasonerType = reasoner;
    }

    public String getReasonerType() {
        return this.reasonerType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

