/*
 * Decompiled with CFR 0.152.
 */
package com.vectorc.mule.rdf.jena.common;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.vectorc.mule.rdf.jena.i18n.JenaMessages;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDFData {
    private static final Log logger = LogFactory.getLog(RDFData.class);
    protected static final Object INIT = new Object();
    protected Model model;
    protected String name;
    protected List<URL> urls;

    public RDFData() {
    }

    public RDFData(List<String> locations) {
        this.setLocations(locations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() throws JenaException {
        if (this.model != null) {
            return;
        }
        Object object = INIT;
        synchronized (object) {
            if (this.model != null) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Loading RDF data");
            }
            Model mergedModel = ModelFactory.createDefaultModel((ReificationStyle)ReificationStyle.Minimal);
            RDFReader reader = mergedModel.getReader();
            reader.setProperty("WARN_REDEFINITION_OF_ID", (Object)"EM_IGNORE");
            mergedModel = this.postInit(mergedModel);
            for (URL url : this.urls) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Reading RDF from URL " + url));
                }
                mergedModel.read(url.toString());
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Total statements in merged model: " + mergedModel.size()));
            }
            this.model = mergedModel;
        }
    }

    protected Model postInit(Model m) {
        return m;
    }

    public Model getModel() throws JenaException {
        this.initialize();
        return this.model;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getLocations() {
        if (this.urls == null) {
            return Collections.emptyList();
        }
        ArrayList<String> locations = new ArrayList<String>(this.urls.size());
        for (URL url : this.urls) {
            locations.add(url.toString());
        }
        return locations;
    }

    public void setLocations(List<String> locations) {
        if (locations == null) {
            return;
        }
        this.urls = new ArrayList<URL>(locations.size());
        for (String strURL : locations) {
            URL url = IOUtils.getResourceAsUrl((String)strURL, RDFData.class);
            if (url != null) {
                this.urls.add(url);
                continue;
            }
            logger.error((Object)JenaMessages.locationCouldNotBeParsedIntoURL(strURL).getMessage());
        }
    }
}

