/*
 * Decompiled with CFR 0.152.
 */
package com.vectorc.mule.rdf.jena.common;

import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.OWLFBRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.OWLMicroReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.OWLMiniReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.RDFSRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasonerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReasonerConfig {
    public static final String JENA_TRANSITIVE = "JenaTransitive";
    public static final String JENA_RDFS = "JenaRDFS";
    public static final String JENA_OWL_MICRO = "JenaOWLMicro";
    public static final String JENA_OWL_MINI = "JenaOWLMini";
    public static final String JENA_OWL_FB = "JenaOWLFB";
    protected static final Log logger = LogFactory.getLog(ReasonerConfig.class);

    public static ReasonerFactory getReasonerFactory(String reasoner) {
        if (reasoner == null) {
            return null;
        }
        if (reasoner.equals(JENA_TRANSITIVE)) {
            return TransitiveReasonerFactory.theInstance();
        }
        if (reasoner.equals(JENA_RDFS)) {
            return RDFSRuleReasonerFactory.theInstance();
        }
        if (reasoner.equals(JENA_OWL_MICRO)) {
            return OWLMicroReasonerFactory.theInstance();
        }
        if (reasoner.equals(JENA_OWL_MINI)) {
            return OWLMiniReasonerFactory.theInstance();
        }
        if (reasoner.equals(JENA_OWL_FB)) {
            return OWLFBRuleReasonerFactory.theInstance();
        }
        return null;
    }
}

