/*
 * Decompiled with CFR 0.152.
 */
package com.vectorc.mule.rdf.jena.filters;

import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.shared.JenaException;
import com.vectorc.mule.rdf.jena.i18n.JenaMessages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.routing.filter.Filter;

public class ConsistencyFilter
implements Filter {
    private final Log logger = LogFactory.getLog(ConsistencyFilter.class);

    public boolean accept(MuleMessage message) {
        return this.accept(message.getPayload());
    }

    public boolean accept(Object payload) {
        if (payload instanceof InfModel) {
            try {
                ValidityReport report = ((InfModel)payload).validate();
                return report.isValid();
            }
            catch (JenaException je) {
                this.logger.error((Object)JenaMessages.reasoningError().getMessage(), (Throwable)je);
                return false;
            }
        }
        this.logger.error((Object)JenaMessages.payloadNotInfModel(payload).getMessage());
        return false;
    }
}

