/*
 * Decompiled with CFR 0.152.
 */
package com.vectorc.mule.rdf.jena.filters;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.shared.JenaException;
import com.vectorc.mule.rdf.jena.i18n.JenaMessages;
import com.vectorc.mule.rdf.jena.util.JenaQueryHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.routing.filter.Filter;

public class SPARQLFilter
implements Filter {
    private static final Log logger = LogFactory.getLog(SPARQLFilter.class);
    private JenaQueryHelper queryHelper;

    public boolean accept(MuleMessage message) {
        Object payload = message.getPayload();
        if (this.queryHelper == null) {
            logger.error((Object)JenaMessages.sparqlQueryNotConfigured());
            return false;
        }
        if (!this.queryHelper.getJenaQuery().isAskType()) {
            logger.error((Object)JenaMessages.sparqlQueryNotASK());
            return false;
        }
        if (payload instanceof Model) {
            logger.debug((Object)"About to execute SPARQL ASK query ");
            logger.debug((Object)this.queryHelper.toString((Model)payload, null, payload));
            boolean result = false;
            try {
                result = this.queryHelper.executeAsk((Model)payload, null, message);
            }
            catch (JenaException je) {
                logger.error((Object)JenaMessages.errorExecutingSPARQLQuery().getMessage(), (Throwable)je);
                return false;
            }
            logger.debug((Object)("Result for SPARQL ASK: " + result));
            return result;
        }
        logger.error((Object)JenaMessages.messagePayloadNotAJenaModel().getMessage());
        return false;
    }

    public JenaQueryHelper getQueryHelper() {
        return this.queryHelper;
    }

    public void setQueryHelper(JenaQueryHelper queryHelper) {
        this.queryHelper = queryHelper;
    }
}

