/*
 * Decompiled with CFR 0.152.
 */
package com.vectorc.mule.rdf.jena.transformers;

import com.hp.hpl.jena.rdf.model.Model;
import com.vectorc.mule.rdf.jena.i18n.JenaMessages;
import com.vectorc.mule.rdf.transformers.AbstractRDFTransformer;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.MessageTypeNotSupportedException;

public class JenaModelToRDF
extends AbstractRDFTransformer {
    private static final Log logger = LogFactory.getLog(JenaModelToRDF.class);

    public JenaModelToRDF() {
        this.registerSourceType(Model.class);
        this.setReturnClass(byte[].class);
    }

    public Object doTransform(Object src, String outputEncoding) throws TransformerException {
        String rdfLang = this.getRdfLanguage();
        String uriBase = this.getURIToUse();
        logger.debug((Object)("Jena Model-To-RDF transforming into format " + rdfLang + " using URI base: '" + uriBase + "'"));
        if (rdfLang == null) {
            throw new TransformerException(JenaMessages.rdfLanguageNotSet(), (Transformer)this);
        }
        if (!(src instanceof Model)) {
            throw new TransformerException((Transformer)this, (Throwable)new MessageTypeNotSupportedException(src, Model.class));
        }
        try {
            Model rdfModel = (Model)src;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            rdfModel.write((OutputStream)baos, rdfLang, uriBase);
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw new TransformerException(JenaMessages.errorSerializingModel(rdfLang), (Transformer)this, (Throwable)e);
        }
    }
}

