/*
 * Decompiled with CFR 0.152.
 */
package com.vectorc.mule.rdf.jena.transformers;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.vectorc.mule.rdf.jena.i18n.JenaMessages;
import com.vectorc.mule.rdf.transformers.AbstractRDFTransformer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;

public class RDFToJenaModel
extends AbstractRDFTransformer {
    private static final Log logger = LogFactory.getLog(RDFToJenaModel.class);

    public RDFToJenaModel() {
        this.registerSourceType(byte[].class);
        this.registerSourceType(String.class);
        this.registerSourceType(InputStream.class);
        this.registerSourceType(Reader.class);
        this.setReturnClass(Model.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doTransform(Object src, String encoding) throws TransformerException {
        String rdfLang = this.getRdfLanguage();
        String uriBase = this.getURIToUse();
        logger.debug((Object)("RDF-To-Jena Model transforming from format " + rdfLang + " using URI base " + this.baseURI));
        if (rdfLang == null) {
            throw new TransformerException(JenaMessages.rdfLanguageNotSet(), (Transformer)this);
        }
        try {
            Model rdfModel = ModelFactory.createDefaultModel((ReificationStyle)ReificationStyle.Minimal);
            if (src instanceof byte[]) {
                rdfModel.read((InputStream)new ByteArrayInputStream((byte[])src), uriBase, rdfLang);
            } else {
                if (src instanceof InputStream) {
                    InputStream is = (InputStream)src;
                    try {
                        rdfModel.read(is, uriBase, rdfLang);
                    }
                    finally {
                        try {
                            is.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
                if (src instanceof Reader) {
                    Reader reader = (Reader)src;
                    try {
                        rdfModel.read(reader, uriBase, rdfLang);
                    }
                    finally {
                        reader.close();
                    }
                } else if (src instanceof String) {
                    rdfModel.read((Reader)new StringReader((String)src), uriBase, rdfLang);
                } else {
                    throw new TransformerException(JenaMessages.messageNotSerializedRDFType(), (Transformer)this);
                }
            }
            return rdfModel;
        }
        catch (IOException ioe) {
            throw new TransformerException(JenaMessages.errorParsingIntoModel(rdfLang), (Transformer)this, (Throwable)ioe);
        }
        catch (JenaException je) {
            throw new TransformerException(JenaMessages.errorParsingIntoModel(rdfLang), (Transformer)this, (Throwable)je);
        }
    }
}

