/*
 * Decompiled with CFR 0.152.
 */
package com.vectorc.mule.rdf.jena.transformers;

import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.shared.JenaException;
import com.vectorc.mule.rdf.jena.common.IncrementalJenaReasoner;
import com.vectorc.mule.rdf.jena.i18n.JenaMessages;
import com.vectorc.mule.rdf.jena.transformers.AbstractJenaModelToJenaModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;

public class ReasoningTransformer
extends AbstractJenaModelToJenaModel {
    private static final Log logger = LogFactory.getLog(ReasoningTransformer.class);
    private IncrementalJenaReasoner reasoner = null;

    protected Model transformModel(Model input) throws TransformerException {
        logger.debug((Object)("About to execute reasoner " + this.reasoner.getReasonerType()));
        try {
            long statementsBefore = 0L;
            long statementsAfter = 0L;
            if (logger.isDebugEnabled()) {
                statementsBefore = input.size();
            }
            InfModel infModel = this.reasoner.executeReasoner(input);
            if (logger.isDebugEnabled()) {
                statementsAfter = infModel.size();
                logger.debug((Object)("Statements in model before inferencing " + statementsBefore + ", statements after " + statementsAfter));
                logger.debug((Object)("Model is consistent: " + infModel.validate().isValid()));
            }
            return infModel;
        }
        catch (JenaException je) {
            throw new TransformerException(JenaMessages.reasoningError(), (Transformer)this, (Throwable)je);
        }
    }

    public void setReasoner(IncrementalJenaReasoner reasoner) {
        this.reasoner = reasoner;
    }

    public IncrementalJenaReasoner getReasoner() {
        return this.reasoner;
    }
}

