/*
 * Decompiled with CFR 0.152.
 */
package com.vectorc.mule.rdf.jena.transformers;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.shared.JenaException;
import com.vectorc.mule.rdf.jena.i18n.JenaMessages;
import com.vectorc.mule.rdf.jena.transformers.AbstractJenaModelToJenaModel;
import com.vectorc.mule.rdf.jena.util.JenaQueryHelper;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;

public class SPARQLTransformer
extends AbstractJenaModelToJenaModel {
    private JenaQueryHelper queryHelper;

    protected Model transformModel(Model input) throws TransformerException {
        if (this.queryHelper == null || this.queryHelper.getJenaQuery() == null) {
            throw new TransformerException(JenaMessages.sparqlQueryNotConfigured(), (Transformer)this);
        }
        Query query = this.queryHelper.getJenaQuery();
        if (query.isConstructType() || query.isDescribeType()) {
            try {
                return (Model)this.queryHelper.execute(input, null, null);
            }
            catch (JenaException je) {
                throw new TransformerException(JenaMessages.errorExecutingSPARQLQuery(), (Transformer)this, (Throwable)je);
            }
        }
        throw new TransformerException(JenaMessages.sparqlQueryNotCONSTRUCTorDESCRIBE(), (Transformer)this);
    }

    public JenaQueryHelper getQueryHelper() {
        return this.queryHelper;
    }

    public void setQueryHelper(JenaQueryHelper queryHelper) {
        this.queryHelper = queryHelper;
    }
}

