/*
 * Decompiled with CFR 0.152.
 */
package com.vectorc.mule.rdf.jena.util;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import java.math.BigInteger;

public class JenaQueryBinding {
    public static final String URI = "URI";
    public static final String BIGINTEGER = "BigInteger";
    public static final String BOOLEAN = "Boolean";
    public static final String CHARACTER = "Character";
    public static final String DOUBLE = "Double";
    public static final String FLOAT = "Float";
    public static final String INTEGER = "Integer";
    public static final String LONG = "Long";
    public static final String STRING = "String";
    private String variable;
    private String type;
    private String typeURI;
    private String value;
    private Object typeObject;

    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public String getType() {
        return this.type.toString();
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTypeURI() {
        return this.typeURI;
    }

    public void setTypeURI(String typeURI) {
        this.typeURI = typeURI;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public RDFNode createValueNode(Model model) {
        return this.createValueNode(model, this.value);
    }

    public RDFNode createValueNode(Model model, String value) {
        if (this.typeURI != null) {
            return model.createTypedLiteral(value, this.typeURI);
        }
        if (this.type != null) {
            if (URI.equals(this.type)) {
                return model.createResource(value);
            }
            if (this.typeObject == null) {
                if (BIGINTEGER.equals(this.type)) {
                    this.typeObject = new BigInteger(value);
                } else if (BOOLEAN.equals(this.type)) {
                    this.typeObject = new Boolean(value);
                } else if (CHARACTER.equals(this.type)) {
                    this.typeObject = new Character(value.charAt(0));
                } else if (DOUBLE.equals(this.type)) {
                    this.typeObject = new Double(value);
                } else if (FLOAT.equals(this.type)) {
                    this.typeObject = new Float(value);
                } else if (INTEGER.equals(this.type)) {
                    this.typeObject = new Integer(value);
                } else if (LONG.equals(this.type)) {
                    this.typeObject = new Long(value);
                } else if (STRING.equals(this.type)) {
                    this.typeObject = value;
                } else {
                    throw new IllegalArgumentException("Unrecognized type: " + this.type);
                }
            }
            return model.createTypedLiteral(this.typeObject);
        }
        return model.createLiteral(value);
    }

    public String toSPARQLString(String value) {
        if (value == null) {
            return null;
        }
        if (value.charAt(0) == '\"' || value.charAt(0) == '\'') {
            return value;
        }
        if (this.typeURI != null) {
            return JenaQueryBinding.toTypedLiteralString(value, this.typeURI);
        }
        if (this.type != null) {
            if (URI.equals(this.type)) {
                return "<" + value + ">";
            }
            if (this.typeObject == null) {
                if (BIGINTEGER.equals(this.type)) {
                    return JenaQueryBinding.toTypedLiteralString(value, "http://www.w3.org/2001/XMLSchema#integer");
                }
                if (BOOLEAN.equals(this.type)) {
                    return JenaQueryBinding.toTypedLiteralString(value, "http://www.w3.org/2001/XMLSchema#boolean");
                }
                if (CHARACTER.equals(this.type)) {
                    return JenaQueryBinding.toTypedLiteralString(value, "http://www.w3.org/2001/XMLSchema#string");
                }
                if (DOUBLE.equals(this.type)) {
                    return JenaQueryBinding.toTypedLiteralString(value, "http://www.w3.org/2001/XMLSchema#double");
                }
                if (FLOAT.equals(this.type)) {
                    return JenaQueryBinding.toTypedLiteralString(value, "http://www.w3.org/2001/XMLSchema#float");
                }
                if (INTEGER.equals(this.type)) {
                    return JenaQueryBinding.toTypedLiteralString(value, "http://www.w3.org/2001/XMLSchema#int");
                }
                if (LONG.equals(this.type)) {
                    return JenaQueryBinding.toTypedLiteralString(value, "http://www.w3.org/2001/XMLSchema#long");
                }
                if (STRING.equals(this.type)) {
                    return JenaQueryBinding.toTypedLiteralString(value, "http://www.w3.org/2001/XMLSchema#string");
                }
            }
        }
        return JenaQueryBinding.toTypedLiteralString(value, null);
    }

    private static String toTypedLiteralString(String value, String typeURI) {
        StringBuilder builder = new StringBuilder();
        builder.append("\"");
        builder.append(value);
        builder.append("\"");
        if (typeURI != null) {
            builder.append("^^<");
            builder.append(typeURI);
            builder.append(">");
        }
        return builder.toString();
    }
}

