/*
 * Decompiled with CFR 0.152.
 */
package com.vectorc.mule.rdf.jena.util;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetRewindable;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.vectorc.mule.rdf.jena.common.IncrementalJenaReasoner;
import com.vectorc.mule.rdf.jena.util.JenaQueryBinding;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.expression.MapPayloadExpressionEvaluator;
import org.mule.expression.MessageHeaderExpressionEvaluator;
import org.mule.util.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JenaQueryHelper {
    private static final Log logger = LogFactory.getLog(JenaQueryHelper.class);
    private Syntax langURI;
    private String strQuery;
    private Query jenaQuery;
    private String queryFilePath;
    private List bindings;
    private IncrementalJenaReasoner reasoner = null;

    public JenaQueryHelper(Syntax langURI) {
        this.langURI = langURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Model model, List additionalBindings, Object message) throws QueryException {
        try {
            model.enterCriticalSection(true);
            Model tmpModel = model;
            if (this.reasoner != null) {
                tmpModel = this.reasoner.executeReasoner(model);
            }
            QuerySolution initialBindings = this.generateInitialBindings(tmpModel, additionalBindings, message);
            QueryExecution qe = QueryExecutionFactory.create((Query)this.getJenaQuery(), (Model)tmpModel, (QuerySolution)initialBindings);
            Object object = this.execute(qe);
            return object;
        }
        finally {
            model.leaveCriticalSection();
        }
    }

    public Object execute(String url, List additionalBindings, Object message) throws QueryException {
        assert (this.reasoner == null);
        Map<String, JenaQueryBinding> mergedBindings = JenaQueryHelper.getMergedBindings(this.bindings, additionalBindings);
        Query queryToUse = mergedBindings.size() == 0 ? this.getJenaQuery() : this.performBindingSubstitution(mergedBindings, message);
        QueryExecution qe = QueryExecutionFactory.sparqlService((String)url, (Query)queryToUse);
        return this.execute(qe);
    }

    public boolean executeAsk(Model model, List additionalBindings, Object message) throws QueryException {
        assert (this.getJenaQuery().isAskType());
        return (Boolean)this.execute(model, additionalBindings, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object execute(QueryExecution qe) throws QueryException {
        logger.debug((Object)"JenaQueryHelper.execute()...");
        try {
            if (this.getJenaQuery().isAskType()) {
                if (qe.execAsk()) {
                    Boolean bl = Boolean.TRUE;
                    return bl;
                }
                Boolean bl = Boolean.FALSE;
                return bl;
            }
            if (this.getJenaQuery().isConstructType()) {
                Model model = qe.execConstruct();
                return model;
            }
            if (this.getJenaQuery().isDescribeType()) {
                Model model = qe.execDescribe();
                return model;
            }
            if (this.getJenaQuery().isSelectType()) {
                ResultSet rs = qe.execSelect();
                ResultSetRewindable resultSetRewindable = ResultSetFactory.copyResults((ResultSet)rs);
                return resultSetRewindable;
            }
            Object var2_7 = null;
            return var2_7;
        }
        finally {
            logger.debug((Object)"JenaQueryHelper.execute() finished");
            if (qe != null) {
                qe.close();
            }
        }
    }

    private QuerySolution generateInitialBindings(Model model, List additionalBindings, Object message) throws QueryException {
        Map<String, JenaQueryBinding> mergedBindings = JenaQueryHelper.getMergedBindings(this.bindings, additionalBindings);
        QuerySolutionMap mergedMap = new QuerySolutionMap();
        for (String var : mergedBindings.keySet()) {
            JenaQueryBinding binding = mergedBindings.get(var);
            String value = JenaQueryHelper.getBindingValue(binding, message);
            if (value == null) continue;
            RDFNode node = binding.createValueNode(model, value);
            mergedMap.add(var, node);
        }
        return mergedMap;
    }

    public static String performBindingSubstitution(String initialQuery, Map<String, JenaQueryBinding> mergedBindings, Object message) {
        String finalQuery = initialQuery;
        for (String var : mergedBindings.keySet()) {
            JenaQueryBinding binding = mergedBindings.get(var);
            String value = JenaQueryHelper.getBindingValue(binding, message);
            if (value == null) continue;
            String sparqlStr = binding.toSPARQLString(value);
            finalQuery = finalQuery.replace("?" + var, sparqlStr);
            finalQuery = finalQuery.replace("$" + var, sparqlStr);
        }
        return finalQuery;
    }

    private Query performBindingSubstitution(Map<String, JenaQueryBinding> mergedBindings, Object message) throws QueryException {
        String queryStr = this.getQueryString();
        assert (queryStr != null);
        return JenaQueryHelper.parseQueryString(JenaQueryHelper.performBindingSubstitution(queryStr, mergedBindings, message), this.langURI);
    }

    private static String getBindingValue(JenaQueryBinding binding, Object message) {
        String value = JenaQueryHelper.getPropertyFromHeaderOrPayload(binding.getVariable(), message);
        if (value == null) {
            value = binding.getValue();
        }
        return value;
    }

    public static String getPropertyFromHeaderOrPayload(String key, Object message) {
        String nonreqKey;
        MapPayloadExpressionEvaluator eval;
        String value = null;
        if (message != null && message instanceof MuleMessage && (value = (String)(eval = new MapPayloadExpressionEvaluator()).evaluate(nonreqKey = key + "?", (MuleMessage)message)) == null) {
            eval = new MessageHeaderExpressionEvaluator();
            value = (String)eval.evaluate(nonreqKey, (MuleMessage)message);
        }
        return value;
    }

    public static Map<String, JenaQueryBinding> getMergedBindings(List bindings, List additionalBindings) {
        HashMap<String, JenaQueryBinding> mergedBindings = new HashMap<String, JenaQueryBinding>();
        if (bindings != null && bindings.size() > 0) {
            for (JenaQueryBinding binding : bindings) {
                mergedBindings.put(binding.getVariable(), binding);
            }
        }
        if (additionalBindings != null && additionalBindings.size() > 0) {
            for (JenaQueryBinding binding : additionalBindings) {
                mergedBindings.put(binding.getVariable(), binding);
            }
        }
        return mergedBindings;
    }

    public Query getJenaQuery() {
        return this.jenaQuery;
    }

    public void setQueryString(String query) {
        try {
            this.jenaQuery = JenaQueryHelper.parseQueryString(query, this.langURI);
        }
        catch (QueryException qe) {
            logger.error((Object)("Error parsing SPARQL query " + query), (Throwable)qe);
            throw new IllegalArgumentException(qe);
        }
    }

    private static Query parseQueryString(String queryStr, Syntax langURI) throws QueryException {
        return QueryFactory.create((String)queryStr, (Syntax)langURI);
    }

    public String getQueryString() {
        if (this.strQuery != null) {
            return this.strQuery;
        }
        if (this.jenaQuery != null) {
            this.strQuery = this.jenaQuery.toString();
            return this.strQuery;
        }
        return null;
    }

    public void setQueryPath(String queryFilePath) {
        this.queryFilePath = queryFilePath;
        try {
            String query = IOUtils.getResourceAsString((String)queryFilePath, JenaQueryHelper.class);
            if (query != null) {
                this.jenaQuery = QueryFactory.create((String)query, (Syntax)this.langURI);
            } else {
                logger.error((Object)("Error reading SPARQL query from path " + this.queryFilePath));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error reading SPARQL query from path " + this.queryFilePath), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public String getQueryPath() {
        return this.queryFilePath;
    }

    public List getBindings() {
        return this.bindings;
    }

    public void setBindings(List bindings) {
        this.bindings = bindings;
    }

    public void setReasoner(IncrementalJenaReasoner reasoner) {
        this.reasoner = reasoner;
    }

    public IncrementalJenaReasoner getReasoner() {
        return this.reasoner;
    }

    public String toString(Model model, List additionalBindings, Object message) {
        QuerySolution initialBindings = this.generateInitialBindings(model, additionalBindings, message);
        StringBuffer buf = new StringBuffer();
        buf.append("query [");
        buf.append(this.getQueryString());
        buf.append("] bindings [");
        buf.append(initialBindings != null ? initialBindings.toString() : "null");
        buf.append("]");
        return buf.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("query [");
        buf.append(this.getQueryString());
        buf.append("] bindings [");
        buf.append(this.bindings != null ? this.bindings.toString() : "null");
        buf.append("]");
        return buf.toString();
    }
}

