/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.batchSubjects;

import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.dto.Epic.EmpiSubjectDto;
import edu.harvard.catalyst.scheduler.entity.ArchivalStatus;
import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.Country;
import edu.harvard.catalyst.scheduler.entity.Ethnicity;
import edu.harvard.catalyst.scheduler.entity.Race;
import edu.harvard.catalyst.scheduler.entity.State;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.entity.SubjectMrn;
import edu.harvard.catalyst.scheduler.persistence.EpicSubjectDAO;
import edu.harvard.catalyst.scheduler.persistence.SubjectDAO;
import edu.harvard.catalyst.scheduler.service.EpicSubjectService;
import edu.harvard.catalyst.scheduler.util.DateUtility;
import edu.harvard.catalyst.scheduler.util.SubjectDataEncryptor;
import java.security.Key;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class BatchSubjects {
    private static final Logger LOG = Logger.getLogger(BatchSubjects.class);
    private final EpicSubjectService epicSubjectService;
    private final SubjectDAO subjectDAO;
    private final EpicSubjectDAO epicSubjectDAO;
    static final String arrow2 = "====> ";
    static final String arrow1 = "--> ";

    @Autowired
    public BatchSubjects(SubjectDAO subjectDAO, @Qualifier(value="encryptionKeyBatch") Key key, @Qualifier(value="subjectSSOTConfigured") EpicSubjectService epicSubjectService, EpicSubjectDAO epicSubjectDAO) {
        this.epicSubjectService = epicSubjectService;
        this.subjectDAO = subjectDAO;
        this.epicSubjectDAO = epicSubjectDAO;
        SubjectDataEncryptor.setEncryptionKey((Key)key);
    }

    public static void main(String[] args) throws SQLException {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("spring-epic-batch-subjects.xml");
        BatchSubjects batchSubjects = (BatchSubjects)context.getBean("batchSubjects");
        batchSubjects.run();
    }

    void run() throws SQLException {
        LOG.info((Object)"\n=======================================================================================");
        LOG.info((Object)("Counted " + this.findNumSubjectMrns() + " SubjectMrns to refresh."));
        List<SubjectMrn> subjectMrns = this.findAllSubjectMrns();
        LOG.info((Object)("Found " + subjectMrns.size() + " SubjectMrns to refresh."));
        int numRefreshed = 0;
        for (SubjectMrn subjectMrn : subjectMrns) {
            Subject subject = subjectMrn.getSubject();
            ArchivalStatus archivalStatus = subject.getArchivalStatus();
            if (archivalStatus == null) {
                LOG.info((Object)("++++++++ Refreshing subject, id: " + subject.getId() + " + via a subjectMrn"));
                if (this.refreshExternalSubject(subjectMrn, true)) {
                    ++numRefreshed;
                }
                LOG.info((Object)("++++++++ Done with subject, id: " + subject.getId()));
                continue;
            }
            LOG.info((Object)("++++++++ Not refreshing subject, id: " + subject.getId() + " + since its archivalStatus is " + archivalStatus));
        }
        LOG.info((Object)("Refreshed a total of " + numRefreshed + " SubjectMrn(s)."));
    }

    List<SubjectMrn> findAllSubjectMrns() throws SQLException {
        return this.subjectDAO.findAllSubjectMrns();
    }

    public int findNumSubjectMrns() {
        return this.subjectDAO.findNumberOfSubjectMrns();
    }

    boolean sanityCheckEmpiMatchCount(EmpiSubjectDto empiSubjectDTO, String institution, Integer id) {
        boolean result = true;
        if (empiSubjectDTO == null) {
            result = false;
        } else {
            EmpiSubjectDto.Patients patients = empiSubjectDTO.getPatients();
            int count = 0;
            if (patients != null && patients.getPatientList() != null) {
                count = patients.getPatientList().size();
            }
            if (count != 1) {
                SchedulerRuntimeException.logDontThrow((String)(this.prefix1(institution, id) + " expected 1 but got " + count + " matches."));
                result = false;
            }
        }
        return result;
    }

    String prefix(String institution, Integer id, String arrow) {
        return "For Subject id: " + id + ", institution: " + institution + ":\n" + arrow;
    }

    String prefix1(String institution, Integer id) {
        return this.prefix(institution, id, arrow1);
    }

    String prefix2(String institution, Integer id) {
        return this.prefix(institution, id, arrow2);
    }

    String decryptMrn(String mrn) {
        return SubjectDataEncryptor.decrypt((String)mrn);
    }

    EmpiSubjectDto.Mrn relevantMrn(EmpiSubjectDto.Patient patient, String institution) {
        List mrnList;
        Optional<EmpiSubjectDto.Mrn> mrnOptional;
        EmpiSubjectDto.Mrn resultMrn = null;
        EmpiSubjectDto.Mrns mrns = patient.getMrns();
        if (mrns != null && mrns.getMrnList() != null && !mrns.getMrnList().isEmpty() && (mrnOptional = (mrnList = mrns.getMrnList()).stream().filter(m -> m.getSite().equalsIgnoreCase(institution)).findFirst()).isPresent()) {
            resultMrn = mrnOptional.get();
        }
        return resultMrn;
    }

    String canonicalPhoneNumber(String input) {
        String result = null;
        if (input != null) {
            result = input.replaceAll("[^\\d]", "");
            result = result.replaceAll("(\\d\\d\\d)(\\d\\d\\d)(\\d\\d\\d\\d)", "($1) $2-$3");
        }
        return result;
    }

    public String imposeUpon(Subject subject, EmpiSubjectDto empiSubjectDto, String institution, SubjectMrn originalSubjectMrn) {
        EmpiSubjectDto.Patient patient = (EmpiSubjectDto.Patient)empiSubjectDto.getPatients().getPatientList().get(0);
        EmpiSubjectDto.Address address = patient.getAddress();
        EmpiSubjectDto.Name name = patient.getName();
        EmpiSubjectDto.Phones phones = patient.getPhones();
        EmpiSubjectDto.Mrn empiMrn = this.relevantMrn(patient, institution);
        String genderEmpi = patient.getGender();
        StringBuilder changes = new StringBuilder();
        changes.append(subject.verboseSetPuid(String.valueOf(patient.getUid())));
        changes.append(subject.verboseSetLastName(name == null ? null : name.getLast()));
        changes.append(subject.verboseSetFirstName(name == null ? null : name.getFirst()));
        changes.append(subject.verboseSetMiddleName(name == null ? null : name.getMiddleInitial()));
        changes.append(subject.verboseSetStreetAddress1(address == null ? null : address.getLine1()));
        changes.append(subject.verboseSetStreetAddress2(address == null ? null : address.getLine2()));
        changes.append(subject.verboseSetCity(address == null ? null : address.getCity()));
        changes.append(subject.verboseSetZip(address == null ? null : address.getZipAsString()));
        changes.append(subject.verboseSetPrimaryContactNumber(phones == null ? null : this.canonicalPhoneNumber(phones.getPrimary())));
        changes.append(subject.verboseSetSecondaryContactNumber(phones == null ? null : this.canonicalPhoneNumber(phones.getSecondary())));
        changes.append(subject.verboseSetGenderEmpi(genderEmpi == null ? null : genderEmpi));
        if (patient.getDobString() != null) {
            Date dobDate = DateUtility.parse((DateFormat)DateUtility.monthDayYear(), (String)patient.getDobString());
            changes.append(subject.verboseSetBirthdate(new Timestamp(dobDate.getTime())));
        }
        this.imposeAndSaveMrn(subject, empiMrn, originalSubjectMrn, changes);
        this.imposeState(subject, patient, changes);
        this.imposeCountry(subject, patient, changes);
        this.imposeRace(subject, patient, changes);
        this.imposeEthnicity(subject, patient, changes);
        return changes.toString();
    }

    void imposeAndSaveMrn(Subject subject, EmpiSubjectDto.Mrn empiMrn, SubjectMrn originalSubjectMrn, StringBuilder changes) {
        if (empiMrn == null) {
            SchedulerRuntimeException.logDontThrow((String)("Could not impose new value of Mrn for Subject: " + subject.getId()));
        } else {
            String change = subject.verboseUpdateMrn(originalSubjectMrn, empiMrn.getStatus());
            if (!change.isEmpty()) {
                changes.append(change);
                this.epicSubjectDAO.updateEntity((BaseEntity)originalSubjectMrn);
            }
        }
    }

    void imposeState(Subject subject, EmpiSubjectDto.Patient patient, StringBuilder changes) {
        String stateString = null;
        EmpiSubjectDto.Address address = patient.getAddress();
        try {
            State stateEntity = null;
            if (address != null && address.getState() != null && !address.getState().isEmpty()) {
                stateString = address.getState();
                stateEntity = (State)this.findEntityByFieldString("State", "name", stateString);
                if (stateEntity == null) {
                    throw new IllegalArgumentException("Null lookup result for State");
                }
                changes.append(subject.verboseSetState(stateEntity));
            } else {
                changes.append(subject.verboseSetState(null));
            }
        }
        catch (Exception e) {
            SchedulerRuntimeException.logDontThrow((String)("Could not impose new value of State, " + stateString + ", for Subject: " + subject.getId()), (Exception)e);
        }
    }

    void imposeCountry(Subject subject, EmpiSubjectDto.Patient patient, StringBuilder changes) {
        String countryString = null;
        EmpiSubjectDto.Address address = patient.getAddress();
        try {
            Country countryEntity = null;
            if (address != null && address.getCountry() != null && !address.getCountry().isEmpty()) {
                countryString = address.getCountry();
                countryEntity = (Country)this.findEntityByFieldString("Country", "name", countryString);
                if (countryEntity == null) {
                    throw new IllegalArgumentException("Null lookup result for Country");
                }
                changes.append(subject.verboseSetCountry(countryEntity));
            } else {
                changes.append(subject.verboseSetCountry(null));
            }
        }
        catch (Exception e) {
            SchedulerRuntimeException.logDontThrow((String)("Could not impose new value of Country, " + countryString + ", for Subject: " + subject.getId()), (Exception)e);
        }
    }

    void imposeRace(Subject subject, EmpiSubjectDto.Patient patient, StringBuilder changes) {
        String raceString = null;
        try {
            Race raceEntity = null;
            if (patient.getOtherPid() != null && patient.getOtherPid().getRace() != null && !patient.getOtherPid().getRace().isEmpty()) {
                raceString = patient.getOtherPid().getRace();
                raceEntity = (Race)this.findEntityByFieldString("Race", "name", raceString);
                if (raceEntity == null) {
                    throw new IllegalArgumentException("Null lookup result for Race");
                }
                changes.append(subject.verboseSetRace(raceEntity));
            } else {
                changes.append(subject.verboseSetRace(null));
            }
        }
        catch (Exception e) {
            SchedulerRuntimeException.logDontThrow((String)("Could not impose new value of Race, " + raceString + ", for Subject: " + subject.getId()), (Exception)e);
        }
    }

    void imposeEthnicity(Subject subject, EmpiSubjectDto.Patient patient, StringBuilder changes) {
        String ethnicityString = null;
        try {
            Ethnicity ethnicityEntity = null;
            if (patient.getEthnicity() != null && patient.getEthnicity().getEthnic1() != null && !patient.getEthnicity().getEthnic1().isEmpty()) {
                ethnicityString = patient.getEthnicity().getEthnic1();
                ethnicityEntity = this.epicSubjectService.lookupEmpiEthnicityString(ethnicityString);
                if (ethnicityEntity == null) {
                    throw new IllegalArgumentException("Null lookup result for Ethnicity");
                }
                changes.append(subject.verboseSetEthnicity(ethnicityEntity));
            } else {
                changes.append(subject.verboseSetEthnicity(null));
            }
        }
        catch (Exception e) {
            SchedulerRuntimeException.logDontThrow((String)("Could not impose new value of Ethnicity, " + ethnicityString + ", for Subject: " + subject.getId()), (Exception)e);
        }
    }

    public BaseEntity findEntityByFieldString(String table, String column, String columnValue) {
        return this.epicSubjectDAO.findEntityByFieldString(table, column, columnValue);
    }

    public boolean refreshExternalSubject(SubjectMrn subjectMrn, boolean tolerateSomeTimeouts) {
        boolean result = true;
        String institution = subjectMrn.getSite();
        Subject subject = subjectMrn.getSubject();
        String mrn = subjectMrn.getMrn();
        String decryptedMrn = SubjectDataEncryptor.decrypt((String)mrn);
        Subject decryptedSubject = SubjectDataEncryptor.decryptSubjectInPlace((Subject)subject);
        Integer id = decryptedSubject.getId();
        EmpiSubjectDto empiSubjectDto = this.epicSubjectService.getSubjectsAsEmpiSubjectDto(null, null, decryptedMrn, null, null, institution, tolerateSomeTimeouts);
        if (this.sanityCheckEmpiMatchCount(empiSubjectDto, institution, id)) {
            String changes = this.imposeUpon(decryptedSubject, empiSubjectDto, institution, subjectMrn);
            String logMessage = "";
            if (!changes.isEmpty()) {
                try {
                    this.epicSubjectDAO.encryptAndSave(decryptedSubject);
                    String wrappedChanges = "Subject " + id + ". Mrn " + decryptedMrn + "-" + subjectMrn.getSite() + "-" + subjectMrn.getStatus() + ": " + changes;
                    String encryptedChanges = SubjectDataEncryptor.encrypt((String)wrappedChanges);
                    int changesLength = encryptedChanges.length();
                    logMessage = this.prefix2(institution, id) + "There are changes for Subject: " + id + ". Encrypted description has length: " + changesLength;
                    LOG.info((Object)logMessage);
                    this.epicSubjectDAO.logNightlyBatchDeltas(encryptedChanges);
                }
                catch (Exception e) {
                    SchedulerRuntimeException.logAndThrow((String)logMessage, (Exception)e);
                }
            } else {
                String message = this.prefix2(institution, id) + "No Changes for Subject: " + id;
                LOG.info((Object)message);
                System.out.println(message + ". MRN=" + decryptedMrn + ". Site=" + subjectMrn.getSite());
            }
        } else {
            String message = this.prefix1(institution, id) + "No (Unique) match from EMPI for Subject: " + id;
            LOG.info((Object)message);
            System.out.println(message + ". MRN=" + decryptedMrn + ". Site=" + subjectMrn.getSite());
            result = false;
        }
        return result;
    }
}

