/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml.trust.httpclient;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.trust.TrustEngine;
import org.opensaml.xml.security.x509.BasicPKIXValidationInformation;
import org.opensaml.xml.security.x509.BasicX509CredentialNameEvaluator;
import org.opensaml.xml.security.x509.CertPathPKIXValidationOptions;
import org.opensaml.xml.security.x509.PKIXTrustEvaluator;
import org.opensaml.xml.security.x509.PKIXValidationInformationResolver;
import org.opensaml.xml.security.x509.PKIXValidationOptions;
import org.opensaml.xml.security.x509.PKIXX509CredentialTrustEngine;
import org.opensaml.xml.security.x509.StaticPKIXValidationInformationResolver;
import org.opensaml.xml.security.x509.X509Credential;
import org.opensaml.xml.security.x509.X509CredentialNameEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.saml.key.KeyManager;
import org.springframework.security.saml.trust.CertPathPKIXTrustEvaluator;
import org.springframework.security.saml.trust.X509KeyManager;
import org.springframework.security.saml.trust.X509TrustManager;
import org.springframework.security.saml.util.SAMLUtil;

public class TLSProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private static final Logger log = LoggerFactory.getLogger(TLSProtocolSocketFactory.class);
    private KeyManager keyManager;
    private String sslHostnameVerification = "default";
    private Set<String> trustedKeys;
    private SecureProtocolSocketFactory socketFactory;

    public TLSProtocolSocketFactory(KeyManager keyManager, Set<String> trustedKeys, String sslHostnameVerification) {
        this.keyManager = keyManager;
        this.sslHostnameVerification = sslHostnameVerification;
        this.trustedKeys = trustedKeys;
        this.socketFactory = this.initializeDelegate();
    }

    public Socket createSocket(String host, int port) throws IOException {
        return this.socketFactory.createSocket(host, port);
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int clientPort) throws IOException {
        return this.socketFactory.createSocket(host, port, localHost, clientPort);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.socketFactory.createSocket(socket, host, port, autoClose);
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort, HttpConnectionParams connParams) throws IOException {
        return this.socketFactory.createSocket(host, port, localHost, localPort, connParams);
    }

    protected SecureProtocolSocketFactory initializeDelegate() {
        CertPathPKIXValidationOptions pkixOptions = new CertPathPKIXValidationOptions();
        PKIXValidationInformationResolver pkixResolver = this.getPKIXResolver();
        CertPathPKIXTrustEvaluator pkixTrustEvaluator = new CertPathPKIXTrustEvaluator((PKIXValidationOptions)pkixOptions);
        PKIXX509CredentialTrustEngine trustEngine = new PKIXX509CredentialTrustEngine(pkixResolver, (PKIXTrustEvaluator)pkixTrustEvaluator, (X509CredentialNameEvaluator)new BasicX509CredentialNameEvaluator());
        X509KeyManager keyManager = new X509KeyManager((X509Credential)this.keyManager.getDefaultCredential());
        X509TrustManager trustManager = new X509TrustManager(new CriteriaSet(), (TrustEngine<X509Credential>)trustEngine);
        HostnameVerifier hostnameVerifier = SAMLUtil.getHostnameVerifier(this.sslHostnameVerification);
        if (this.isHostnameVerificationSupported()) {
            return new org.opensaml.ws.soap.client.http.TLSProtocolSocketFactory((javax.net.ssl.X509KeyManager)keyManager, (javax.net.ssl.X509TrustManager)trustManager, hostnameVerifier);
        }
        return new org.opensaml.ws.soap.client.http.TLSProtocolSocketFactory((javax.net.ssl.X509KeyManager)keyManager, (javax.net.ssl.X509TrustManager)trustManager);
    }

    protected PKIXValidationInformationResolver getPKIXResolver() {
        if (this.trustedKeys == null) {
            this.trustedKeys = this.keyManager.getAvailableCredentials();
        }
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>(this.trustedKeys.size());
        for (String key : this.trustedKeys) {
            log.debug("Adding PKIX trust anchor {} for SSL/TLS verification {}", (Object)key);
            certificates.add(this.keyManager.getCertificate(key));
        }
        LinkedList<BasicPKIXValidationInformation> info = new LinkedList<BasicPKIXValidationInformation>();
        info.add(new BasicPKIXValidationInformation(certificates, null, Integer.valueOf(4)));
        return new StaticPKIXValidationInformationResolver(info, null);
    }

    protected boolean isHostnameVerificationSupported() {
        try {
            org.opensaml.ws.soap.client.http.TLSProtocolSocketFactory.class.getConstructor(javax.net.ssl.X509KeyManager.class, javax.net.ssl.X509TrustManager.class, HostnameVerifier.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            log.warn("HostnameVerification is not supported, update your OpenSAML libraries");
            return false;
        }
    }
}

