/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.wssecurity.impl;

import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.opensaml.ws.wssecurity.AttributedDateTime;
import org.opensaml.ws.wssecurity.IdBearing;
import org.opensaml.ws.wssecurity.impl.AbstractWSSecurityObject;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.AttributeMap;

public class AttributedDateTimeImpl
extends AbstractWSSecurityObject
implements AttributedDateTime {
    private DateTimeFormatter formatter = ISODateTimeFormat.dateTime().withChronology((Chronology)ISOChronology.getInstanceUTC());
    private DateTime dateTimeValue;
    private String stringValue;
    private String id;
    private AttributeMap unknownAttributes = new AttributeMap((XMLObject)this);

    public AttributedDateTimeImpl(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Override
    public DateTime getDateTime() {
        return this.dateTimeValue;
    }

    @Override
    public void setDateTime(DateTime newDateTime) {
        this.dateTimeValue = newDateTime;
        String formattedDateTime = this.formatter.print((ReadableInstant)this.dateTimeValue);
        this.stringValue = this.prepareForAssignment(this.stringValue, formattedDateTime);
    }

    public String getValue() {
        return this.stringValue;
    }

    public void setValue(String newValue) {
        this.dateTimeValue = new DateTime((Object)newValue).withChronology((Chronology)ISOChronology.getInstanceUTC());
        this.stringValue = this.prepareForAssignment(this.stringValue, newValue);
    }

    @Override
    public String getWSUId() {
        return this.id;
    }

    @Override
    public void setWSUId(String newId) {
        String oldID = this.id;
        this.id = this.prepareForAssignment(this.id, newId);
        this.registerOwnID(oldID, this.id);
        this.manageQualifiedAttributeNamespace(IdBearing.WSU_ID_ATTR_NAME, this.id != null);
    }

    public AttributeMap getUnknownAttributes() {
        return this.unknownAttributes;
    }

    @Override
    public DateTimeFormatter getDateTimeFormatter() {
        return this.formatter;
    }

    @Override
    public void setDateTimeFormatter(DateTimeFormatter newFormatter) {
        if (newFormatter == null) {
            throw new IllegalArgumentException("The specified DateTimeFormatter may not be null");
        }
        this.formatter = newFormatter;
        this.setDateTime(this.getDateTime());
    }
}

