/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto.response;

import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.entity.BookedVisit;
import edu.harvard.catalyst.scheduler.entity.Study;
import edu.harvard.catalyst.scheduler.entity.SubjectMrn;
import edu.harvard.catalyst.scheduler.entity.User;
import java.util.Date;

public class CancellationsReportResponseDTO {
    private String asrName;
    private Date cancelDate;
    private String cancelStatus;
    private String catalystId;
    private String irb;
    private String localId;
    private String mrn;
    private String piFirstName;
    private String piMiddleName;
    private String piLastName;
    private Date scheduledDate;
    private Date scheduledStartTime;
    private Date scheduledEndTime;
    private String studyName;
    private String subjectFirstName;
    private String subjectMiddleName;
    private String subjectLastName;
    private String user;
    private String visitName;
    private String visitTypeName;

    public CancellationsReportResponseDTO(BookedVisit bookedVisit) {
        Study study;
        if (bookedVisit == null) {
            SchedulerRuntimeException.logAndThrow("BookedVisit parameter should be non-null");
        }
        if ((study = bookedVisit.getStudy()) == null) {
            SchedulerRuntimeException.logAndThrow("Study field of BookedVisit parameter should be non-null");
        }
        this.asrName = bookedVisit.getCancelStatusReason().getName();
        this.cancelDate = bookedVisit.getCancelDate();
        this.cancelStatus = "";
        if (bookedVisit.getCancelStatus() != null) {
            this.cancelStatus = bookedVisit.getCancelStatus().getName();
        }
        this.catalystId = "";
        if (study.getCatalystId() != null) {
            this.catalystId = study.getCatalystId();
        }
        this.irb = "";
        if (study.getIrb() != null) {
            this.irb = study.getIrb();
        }
        this.localId = study.getLocalId();
        User investigator = study.getInvestigator();
        if (investigator != null) {
            this.piFirstName = study.getInvestigator().getFirstName();
            this.piMiddleName = study.getInvestigator().getMiddleName();
            this.piLastName = study.getInvestigator().getLastName();
        } else {
            this.piFirstName = "";
            this.piMiddleName = "";
            this.piLastName = "N/A";
        }
        this.scheduledDate = bookedVisit.getSchedulingTime();
        this.scheduledStartTime = bookedVisit.getScheduledStartTime();
        this.scheduledEndTime = bookedVisit.getScheduledEndTime();
        this.studyName = study.getName();
        SubjectMrn subjectMrn = bookedVisit.getSubjectMrnDecrypted();
        this.subjectFirstName = subjectMrn == null ? "No Subject Assigned" : subjectMrn.getSubject().getFirstName();
        this.subjectMiddleName = subjectMrn == null ? "No Subject Assigned" : subjectMrn.getSubject().getMiddleName();
        this.subjectLastName = subjectMrn == null ? "No Subject Assigned" : subjectMrn.getSubject().getLastName();
        this.mrn = subjectMrn == null ? "N/A" : subjectMrn.getMrn();
        this.user = bookedVisit.getSchedulingUserEcommonsId();
        this.visitName = bookedVisit.getVisitTemplate().getName();
        this.visitTypeName = bookedVisit.getVisitTemplate().getVisitType().getName();
    }
}

