/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.entity;

import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.Resource;
import edu.harvard.catalyst.scheduler.entity.TimeBoundedIdentity;
import edu.harvard.catalyst.scheduler.entity.TimeBoundedIdentityAble;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="resource_schedule")
public class ResourceSchedule
extends BaseEntity
implements Serializable,
TimeBoundedIdentityAble {
    private static final long serialVersionUID = 5189764272430222862L;
    private Resource resource;
    private Date startTime;
    private Date endTime;
    private Integer dayOfWeek;
    private Integer quantity;
    private boolean override;

    @Deprecated
    public ResourceSchedule() {
        this(null, null, null, null, null, false);
    }

    public ResourceSchedule(Resource resource, Date startTime, Date endTime, Integer dayOfWeek, Integer quantity, boolean override) {
        super(null);
        this.resource = resource;
        this.startTime = startTime;
        this.endTime = endTime;
        this.dayOfWeek = dayOfWeek;
        this.quantity = quantity;
        this.override = override;
    }

    @JoinColumn(name="resource", referencedColumnName="id")
    @ManyToOne(optional=false)
    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    @Column(name="start_time")
    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @Column(name="override")
    public boolean getOverride() {
        return this.override;
    }

    public void setOverride(boolean override) {
        this.override = override;
    }

    @Column(name="end_time")
    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @Column(name="quantity")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    @Column(name="day_of_week")
    public Integer getDayOfWeek() {
        return this.dayOfWeek;
    }

    public void setDayOfWeek(Integer dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public String toString() {
        return "ResourceSchedule [id=" + this.id + ", getId()=" + this.getId() + "]";
    }

    @Override
    public TimeBoundedIdentity asTimeBoundedEntity() {
        return new TimeBoundedIdentity(this.startTime, this.endTime, this.id, this.quantity);
    }

    public static List<TimeBoundedIdentity> toTimeBoundedIdentityList(List<ResourceSchedule> list) {
        ArrayList<TimeBoundedIdentity> result = new ArrayList<TimeBoundedIdentity>();
        if (list != null) {
            for (ResourceSchedule resourceSchedule : list) {
                TimeBoundedIdentity timeBoundedIdentity = resourceSchedule.asTimeBoundedEntity();
                result.add(timeBoundedIdentity);
            }
        }
        return result;
    }
}

