/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.persistence;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import edu.harvard.catalyst.hccrc.core.util.ListUtils;
import edu.harvard.catalyst.scheduler.dto.SearchDTO;
import edu.harvard.catalyst.scheduler.dto.response.ResourceScheduleResponse;
import edu.harvard.catalyst.scheduler.dto.response.ResourcesResponse;
import edu.harvard.catalyst.scheduler.dto.response.SublocationClosureIntervalResponse;
import edu.harvard.catalyst.scheduler.entity.BookedResource;
import edu.harvard.catalyst.scheduler.entity.Institution;
import edu.harvard.catalyst.scheduler.entity.LineLevelAnnotations;
import edu.harvard.catalyst.scheduler.entity.OverrideBookedResourceAnnotations;
import edu.harvard.catalyst.scheduler.entity.Resource;
import edu.harvard.catalyst.scheduler.entity.ResourceAlternate;
import edu.harvard.catalyst.scheduler.entity.ResourceAnnotation;
import edu.harvard.catalyst.scheduler.entity.ResourceSchedule;
import edu.harvard.catalyst.scheduler.entity.ResourceSublocation;
import edu.harvard.catalyst.scheduler.entity.ResourceType;
import edu.harvard.catalyst.scheduler.entity.Sublocation;
import edu.harvard.catalyst.scheduler.entity.SublocationClosureInterval;
import edu.harvard.catalyst.scheduler.entity.TemplateResource;
import edu.harvard.catalyst.scheduler.entity.TemplateResourceAnnotations;
import edu.harvard.catalyst.scheduler.persistence.SiteDAO;
import edu.harvard.catalyst.scheduler.util.DateUtility;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class ResourceDAO
extends SiteDAO {
    public Institution findInstitutionById(int id) {
        return this.findById(Institution.class, id);
    }

    public Sublocation findSublocationById(int id) {
        return this.findById(Sublocation.class, id);
    }

    public LineLevelAnnotations findLineLevelAnnotationsById(int id) {
        return this.findById(LineLevelAnnotations.class, id);
    }

    public TemplateResource findTemplateResourceById(int id) {
        return this.findById(TemplateResource.class, id);
    }

    public Resource findResourceById(int id) {
        return this.findById(Resource.class, id);
    }

    public ResourceType findResourceTypeById(int id) {
        return ResourceType.findById(id).orElse(null);
    }

    public SublocationClosureInterval findBySublocationClosureIntervalId(Integer id) {
        return this.findById(SublocationClosureInterval.class, id);
    }

    public List<Sublocation> getSublocations() {
        Criteria criteria = this.newCriteria(Sublocation.class).addOrder(Order.asc((String)"name"));
        List sublocations = criteria.list();
        HashSet allowedNames = Sets.newHashSet((Object[])new String[]{"non crc", "off institution"});
        List otherSublocationList = ListUtils.enrich((List)sublocations).filter(sublocation -> allowedNames.contains(sublocation.getName().toLowerCase())).toList();
        sublocations.removeAll(otherSublocationList);
        sublocations.addAll(otherSublocationList);
        return sublocations;
    }

    public List<Institution> getInstitutions() {
        return this.findAll(Institution.class);
    }

    public List<ResourceSublocation> getResourceSublocations() {
        return this.findAll(ResourceSublocation.class);
    }

    public List<ResourceType> getResourceTypes() {
        return ResourceType.valueList();
    }

    public List<SublocationClosureInterval> getSublocationClosureIntervals() {
        return this.findAll(SublocationClosureInterval.class);
    }

    public List<String> getAllResourceNames() {
        String findResource = "SELECT r.name FROM Resource r ORDER by r.name ASC";
        Query query = this.newQuery("SELECT r.name FROM Resource r ORDER by r.name ASC");
        return query.list();
    }

    public List<LineLevelAnnotations> getAllLineLevelAnnotations() {
        String queryString = "SELECT lla FROM LineLevelAnnotations lla ORDER by lla.name ASC";
        Query query = this.newQuery("SELECT lla FROM LineLevelAnnotations lla ORDER by lla.name ASC");
        return query.list();
    }

    public List<LineLevelAnnotations> getNursingLineLevelAnnotations() {
        String queryString = "SELECT lla FROM LineLevelAnnotations lla WHERE lla.id IN(44, 19, 43, 2, 3, 68, 31, 29, 69, 30, 28, 37, 20, 66, 6, 39, 40, 41, 9, 10, 7, 8, 12, 13, 14, 15, 16, 17, 11, 18, 38, 42, 27, 22, 21, 24, 23, 26, 25, 36, 52, 34, 33, 70, 71, 35, 67, 32,1, 5, 4) ORDER by lla.name ASC";
        Query query = this.newQuery("SELECT lla FROM LineLevelAnnotations lla WHERE lla.id IN(44, 19, 43, 2, 3, 68, 31, 29, 69, 30, 28, 37, 20, 66, 6, 39, 40, 41, 9, 10, 7, 8, 12, 13, 14, 15, 16, 17, 11, 18, 38, 42, 27, 22, 21, 24, 23, 26, 25, 36, 52, 34, 33, 70, 71, 35, 67, 32,1, 5, 4) ORDER by lla.name ASC");
        return query.list();
    }

    public List<LineLevelAnnotations> getNutritionLineLevelAnnotations() {
        String queryString = "SELECT lla FROM LineLevelAnnotations lla WHERE lla.id IN(19, 58, 59, 63, 66, 65, 60, 46, 47, 48, 64, 49, 50, 51, 27, 22, 21, 26, 25, 61, 62, 52, 32, 1) ORDER by lla.name ASC";
        Query query = this.newQuery("SELECT lla FROM LineLevelAnnotations lla WHERE lla.id IN(19, 58, 59, 63, 66, 65, 60, 46, 47, 48, 64, 49, 50, 51, 27, 22, 21, 26, 25, 61, 62, 52, 32, 1) ORDER by lla.name ASC");
        return query.list();
    }

    public List<LineLevelAnnotations> getEquipmentlLineLevelAnnotations() {
        String queryString = "SELECT lla FROM LineLevelAnnotations lla WHERE lla.id IN(59, 58, 53, 54, 57, 55, 56, 72) ORDER by lla.name ASC";
        Query query = this.newQuery("SELECT lla FROM LineLevelAnnotations lla WHERE lla.id IN(59, 58, 53, 54, 57, 55, 56, 72) ORDER by lla.name ASC");
        return query.list();
    }

    public List<LineLevelAnnotations> getLabLineLevelAnnotations() {
        String queryString = "SELECT lla FROM LineLevelAnnotations lla WHERE lla.id IN(62) ORDER by lla.name ASC";
        Query query = this.newQuery("SELECT lla FROM LineLevelAnnotations lla WHERE lla.id IN(62) ORDER by lla.name ASC");
        return query.list();
    }

    public List<LineLevelAnnotations> getRoomLineLevelAnnotations() {
        String queryString = "SELECT lla FROM LineLevelAnnotations lla WHERE lla.id IN(62) ORDER by lla.name ASC";
        Query query = this.newQuery("SELECT lla FROM LineLevelAnnotations lla WHERE lla.id IN(62) ORDER by lla.name ASC");
        return query.list();
    }

    public List<Resource> getRooms() {
        List<Resource> resourcesWithSublocations = this.findResourcesActiveInSublocations();
        return ListUtils.enrich(resourcesWithSublocations).filter(this::isRoomResource).distinct().toList();
    }

    private boolean isRoomResource(Resource r) {
        return r.getResourceType().isRoom();
    }

    public List<Sublocation> findSublocations(Institution institution) {
        Criteria crit = this.newCriteria(Sublocation.class).add((Criterion)Restrictions.eq((String)"institution", (Object)institution));
        return crit.list();
    }

    public List<Resource> findResourcesActiveInSublocations() {
        String queryString = "select r from Resource r, ResourceSublocation rs where rs.resource = r.id and rs.active is TRUE order by r.name";
        Query query = this.newQuery("select r from Resource r, ResourceSublocation rs where rs.resource = r.id and rs.active is TRUE order by r.name");
        return query.list();
    }

    public List<ResourceAnnotation> findResourcesAnnotationsByResource(Resource resource) {
        Criteria criteria = this.newCriteria(ResourceAnnotation.class);
        criteria.add((Criterion)Restrictions.eq((String)"resource", (Object)resource));
        return criteria.list();
    }

    public List<OverrideBookedResourceAnnotations> findOverrideBookedResourceAnnotationsByBookedResource(BookedResource bookedResource) {
        Criteria criteria = this.newCriteria(OverrideBookedResourceAnnotations.class);
        criteria.add((Criterion)Restrictions.eq((String)"bookedResource", (Object)bookedResource));
        return criteria.list();
    }

    public List<TemplateResourceAnnotations> findTemplateAnnotationsByTemplateResource(TemplateResource templateResource) {
        Criteria criteria = this.newCriteria(TemplateResourceAnnotations.class);
        criteria.add((Criterion)Restrictions.eq((String)"templateResource", (Object)templateResource));
        return criteria.list();
    }

    public TemplateResourceAnnotations findTemplateAnnotationsByTemplateResourceAndLineLevel(TemplateResource templateResource, LineLevelAnnotations lineLevelAnnotations) {
        Criteria criteria = this.newCriteria(TemplateResourceAnnotations.class);
        criteria.add((Criterion)Restrictions.eq((String)"templateResource", (Object)templateResource));
        criteria.add((Criterion)Restrictions.eq((String)"lineLevelAnnotations", (Object)lineLevelAnnotations));
        return (TemplateResourceAnnotations)criteria.uniqueResult();
    }

    public OverrideBookedResourceAnnotations findBookedResourceAnnotationsByBookedResourceAndLineLevel(BookedResource bookedResource, LineLevelAnnotations lineLevelAnnotations) {
        Criteria criteria = this.newCriteria(OverrideBookedResourceAnnotations.class);
        criteria.add((Criterion)Restrictions.eq((String)"bookedResource", (Object)bookedResource));
        criteria.add((Criterion)Restrictions.eq((String)"lineLevelAnnotations", (Object)lineLevelAnnotations));
        return (OverrideBookedResourceAnnotations)criteria.uniqueResult();
    }

    public List<Resource> findRoomResourcesListedInResourceSublocation(String sublocations) {
        return this.findResourcesWithSublocationsByResourceType(ResourceType.Room, sublocations);
    }

    public List<Resource> findNursingResourcesListedInResourceSublocation(String sublocations) {
        return this.findResourcesWithSublocationsByResourceType(ResourceType.Nursing, sublocations);
    }

    public List<Resource> findNutritionResourcesListedInResourceSublocation(String sublocations) {
        return this.findResourcesWithSublocationsByResourceType(ResourceType.Nutrition, sublocations);
    }

    private List<Resource> findResourcesWithSublocationsByResourceType(ResourceType resourceType, String sublocations) {
        boolean anySublocations = sublocations != null;
        String suffix = anySublocations ? " AND s.name like (:sublocations) " : "";
        String findResource = "SELECT r FROM Resource r, ResourceSublocation rs, Sublocation s  WHERE r.resourceType = :resourceType  AND rs.sublocation = s.id and rs.resource = r.id " + suffix;
        Query query = this.newQuery(findResource).setParameter("resourceType", (Object)resourceType);
        if (anySublocations) {
            query.setParameter("sublocations", (Object)sublocations);
        }
        return query.list();
    }

    public List<Resource> findResourcesNotListedInResourceSublocation() {
        Criteria criteria = this.newCriteria(Resource.class);
        criteria.add(Restrictions.isEmpty((String)"sublocations"));
        return criteria.list();
    }

    public Resource findResourceByName(String resource) {
        Criteria crit = this.newCriteria(Resource.class).add((Criterion)Restrictions.eq((String)"name", (Object)resource));
        return (Resource)crit.uniqueResult();
    }

    public List<ResourceSchedule> findExceptionSchedule(Resource resource, Date startDate, Date endDate, boolean override) {
        String findExceptionSchedule = "SELECT s FROM ResourceSchedule s WHERE s.resource = :resource AND s.override = :override AND  ((:startTime between s.startTime and s.endTime)  or (:endTime between s.startTime and s.endTime)  or (s.startTime >= :startTime and s.endTime <= :endTime))";
        Query query = this.newQuery("SELECT s FROM ResourceSchedule s WHERE s.resource = :resource AND s.override = :override AND  ((:startTime between s.startTime and s.endTime)  or (:endTime between s.startTime and s.endTime)  or (s.startTime >= :startTime and s.endTime <= :endTime))");
        query.setParameter("resource", (Object)resource);
        query.setParameter("override", (Object)override);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        return query.list();
    }

    public List<ResourceSchedule> findTemporaryAdjustmentsByResource(Resource resource, Date startDate, Date endDate, boolean override) {
        String findExceptionSchedule = "SELECT s FROM ResourceSchedule s WHERE s.resource = :resource AND s.override = :override AND  ((:startTime >= s.startTime and :startTime < s.endTime)  or (:endTime > s.startTime and :endTime <= s.endTime)  or (s.startTime >= :startTime and s.endTime <= :endTime)) ORDER BY s.startTime";
        Query query = this.newQuery("SELECT s FROM ResourceSchedule s WHERE s.resource = :resource AND s.override = :override AND  ((:startTime >= s.startTime and :startTime < s.endTime)  or (:endTime > s.startTime and :endTime <= s.endTime)  or (s.startTime >= :startTime and s.endTime <= :endTime)) ORDER BY s.startTime");
        query.setParameter("resource", (Object)resource);
        query.setParameter("override", (Object)override);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        return query.list();
    }

    public List<ResourceSchedule> findResourceScheduleByResource(Resource resource, boolean override) {
        Criteria crit = this.newCriteria(ResourceSchedule.class);
        crit.add((Criterion)Restrictions.eq((String)"resource", (Object)resource));
        crit.add((Criterion)Restrictions.eq((String)"override", (Object)override));
        return crit.list();
    }

    public List<ResourceSchedule> findResourceScheduleByResource(Resource resource, List<Integer> daysOfWeek, boolean override) {
        Criteria crit = this.newCriteria(ResourceSchedule.class);
        crit.add((Criterion)Restrictions.eq((String)"resource", (Object)resource));
        crit.add(Restrictions.in((String)"dayOfWeek", daysOfWeek));
        crit.add((Criterion)Restrictions.eq((String)"override", (Object)override));
        crit.addOrder(Order.asc((String)"startTime"));
        return crit.list();
    }

    public List<SublocationClosureInterval> findSublocationSchedule(Sublocation sublocations) {
        String findExceptionSchedule = "SELECT a FROM SublocationClosureInterval a WHERE a.sublocation = :sublocation ";
        Query query = this.newQuery("SELECT a FROM SublocationClosureInterval a WHERE a.sublocation = :sublocation ").setParameter("sublocation", (Object)sublocations);
        return query.list();
    }

    public ResourceSchedule findResourceScheduleById(int id) {
        return this.findById(ResourceSchedule.class, id);
    }

    public ResourceScheduleResponse resourceScheduleById(int id) {
        String endTime;
        String startTime;
        int dayOfWeek;
        ResourceSchedule rs = this.findResourceScheduleById(id);
        if (!rs.getOverride()) {
            dayOfWeek = rs.getDayOfWeek();
            startTime = ResourceDAO.formatHourMinute(rs.getStartTime());
            endTime = ResourceDAO.formatHourMinute(rs.getEndTime());
        } else {
            dayOfWeek = 1;
            startTime = ResourceDAO.formatDateTime(rs.getStartTime());
            endTime = ResourceDAO.formatDateTime(rs.getEndTime());
        }
        return new ResourceScheduleResponse(rs.getId(), dayOfWeek, startTime, endTime, rs.getQuantity(), 1L);
    }

    private static String formatDateTime(Date date) {
        return DateUtility.format(DateUtility.dateTime(), date);
    }

    private static String formatHourMinute(Date date) {
        return DateUtility.format(DateUtility.hourMin(), date);
    }

    public List<ResourceAlternate> findResourceAlternates(Resource resource) {
        Criteria crit = this.newCriteria(ResourceAlternate.class).add((Criterion)Restrictions.eq((String)"sourceResource", (Object)resource));
        return crit.list();
    }

    public ResourcesResponse findResourceDetail(Resource resource) {
        String findResourceDetail = "SELECT rs FROM ResourceSublocation rs  WHERE rs.resource = :resource ";
        Query query = this.newQuery("SELECT rs FROM ResourceSublocation rs  WHERE rs.resource = :resource ").setParameter("resource", (Object)resource);
        ResourceSublocation result = (ResourceSublocation)query.uniqueResult();
        return new ResourcesResponse(result.getId(), result.getResource().getId(), result.getResource().getName(), result.getResource().getResourceType().getName(), result.getSublocation().getId(), result.getSublocation().getName(), result.isActive(), resource.getSharedResource(), resource.getSharedResourceNotes(), 1L);
    }

    public List<ResourcesResponse> findResourceListWithSublocation(String sortBy, String orderBy, String status, int page, int maxResults, List<SearchDTO.SearchItem> searchItems) {
        StringBuffer queryStringBuffer = new StringBuffer();
        queryStringBuffer.append("SELECT r, rs, s FROM Resource r, ResourceSublocation rs, Sublocation s ");
        queryStringBuffer.append("WHERE rs.resource = r.id and rs.sublocation = s.id ");
        HashMap statusFilterMap = Maps.newHashMap();
        statusFilterMap.put("active", "and rs.active = TRUE ");
        statusFilterMap.put("inactive", "and rs.active = FALSE ");
        statusFilterMap.put("both", "");
        queryStringBuffer.append((String)statusFilterMap.get(status));
        String totalSearchClause = "";
        if (searchItems != null && !searchItems.isEmpty()) {
            HashMap itemKeyToColumn = Maps.newHashMap();
            itemKeyToColumn.put("resourceName", "r.name");
            itemKeyToColumn.put("resourceType", "r.resourceType");
            itemKeyToColumn.put("resourceSublocation", "s.name");
            List searchClauses = searchItems.stream().filter(si -> si.getValue() != null && !si.getValue().isEmpty()).map(si -> "(" + (String)itemKeyToColumn.get(si.getKey()) + " like '%" + si.getValue() + "%')").collect(Collectors.toList());
            String conjunction = " AND ";
            if (!searchClauses.isEmpty()) {
                totalSearchClause = "AND (" + Joiner.on((String)conjunction).join(searchClauses) + ") ";
            }
        }
        queryStringBuffer.append(totalSearchClause);
        queryStringBuffer.append("order by " + sortBy + " " + orderBy);
        String queryString = queryStringBuffer.toString();
        Query query = this.newQuery(queryString);
        long total = query.list().size();
        int offset = (page - 1) * maxResults;
        query.setFirstResult(offset);
        query.setMaxResults(maxResults);
        List resultSet = query.list();
        return ListUtils.enrich((List)resultSet).map(resultRow -> {
            Resource resource = (Resource)resultRow[0];
            ResourceSublocation resourceSublocation = (ResourceSublocation)resultRow[1];
            return new ResourcesResponse(resource.getId(), resourceSublocation.getResource().getId(), resource.getName(), resource.getResourceType().getName(), resourceSublocation.getSublocation().getId(), resourceSublocation.getSublocation().getName(), resourceSublocation.isActive(), total);
        }).toList();
    }

    public List<ResourceScheduleResponse> findResourceSchedulesByResource(Resource resource, boolean override, String sortBy, String orderBy, int page, int maxResults) {
        String sortOn = sortBy.equalsIgnoreCase("da.startTime") ? " da.startTime " + orderBy + ", da.endTime " : (sortBy.equalsIgnoreCase("da.endTime") ? " da.endTime " + orderBy + ", da.startTime " : sortBy);
        String findResource = "SELECT da FROM ResourceSchedule da  WHERE da.resource = :resource and da.override = :override  order by " + sortOn + " " + orderBy;
        Query query = this.newQuery(findResource).setParameter("resource", (Object)resource).setParameter("override", (Object)override);
        long total = query.list().size();
        int offset = (page - 1) * maxResults;
        query.setFirstResult(offset);
        query.setMaxResults(maxResults);
        List resultSet = query.list();
        return ListUtils.enrich((List)resultSet).map(resultRow -> new ResourceScheduleResponse(resultRow.getId(), resultRow.getDayOfWeek(), DateUtility.format(DateUtility.hourMin(), resultRow.getStartTime()), DateUtility.format(DateUtility.hourMin(), resultRow.getEndTime()), resultRow.getQuantity(), total)).toList();
    }

    public List<ResourceScheduleResponse> findTemporarySchedulesByResource(Resource resource, boolean override, String sortBy, String orderBy, int page, int maxResults) {
        Calendar today = Calendar.getInstance();
        today.add(5, -181);
        Date dayBeforeSixMonths = new Date(today.getTimeInMillis());
        String deleteTempResource = "DELETE ResourceSchedule da WHERE da.resource =:resource and da.override =:override and da.endTime < :dayBeforeSixMonths";
        Query query = this.newQuery("DELETE ResourceSchedule da WHERE da.resource =:resource and da.override =:override and da.endTime < :dayBeforeSixMonths");
        query.setParameter("resource", (Object)resource);
        query.setParameter("override", (Object)override);
        query.setParameter("dayBeforeSixMonths", (Object)dayBeforeSixMonths);
        query.executeUpdate();
        String sortOn = this.makeSortOn(sortBy, orderBy);
        String findResource = "SELECT da FROM ResourceSchedule da  WHERE da.resource =:resource and da.override =:override  order by " + sortOn + " " + orderBy;
        Query query1 = this.newQuery(findResource).setParameter("resource", (Object)resource).setParameter("override", (Object)override);
        int offset = (page - 1) * maxResults;
        query1.setFirstResult(offset);
        query1.setMaxResults(maxResults);
        List resultSet = query1.list();
        Long total = this.findResourceScheduleCount(resource, override);
        return ListUtils.enrich((List)resultSet).map(resultRow -> new ResourceScheduleResponse(resultRow.getId(), 1, DateUtility.format(DateUtility.dateTime(), resultRow.getStartTime()), DateUtility.format(DateUtility.dateTime(), resultRow.getEndTime()), resultRow.getQuantity(), total)).toList();
    }

    private String makeSortOn(String sortBy, String orderBy) {
        if (sortBy.equalsIgnoreCase("da.startTime")) {
            return " da.startTime " + orderBy + ", da.endTime ";
        }
        if (sortBy.equalsIgnoreCase("da.endTime")) {
            return " da.endTime " + orderBy + ", da.startTime ";
        }
        return sortBy;
    }

    Long findResourceScheduleCount(Resource resource, boolean override) {
        String findCount = "SELECT count(da) FROM ResourceSchedule da  WHERE da.resource = :resource and da.override = :override ";
        Query query = this.newQuery("SELECT count(da) FROM ResourceSchedule da  WHERE da.resource = :resource and da.override = :override ").setParameter("resource", (Object)resource).setParameter("override", (Object)override);
        return (Long)query.uniqueResult();
    }

    public List<ResourcesResponse> findResourceAlternatesByResource(Resource resource, String sortBy, String orderBy, int page, int maxResults) {
        String findResource = "SELECT ra, rs FROM ResourceAlternate ra, ResourceSublocation rs  WHERE ra.sourceResource =:resource and rs.resource = ra.alternateResource  order by " + sortBy + " " + orderBy;
        Query query = this.newQuery(findResource).setParameter("resource", (Object)resource);
        Long total = query.list().size();
        int offset = (page - 1) * maxResults;
        query.setFirstResult(offset);
        query.setMaxResults(maxResults);
        List resultSet = query.list();
        Function<Object[], ResourcesResponse> toResponse = resultRow -> {
            ResourceAlternate resourceAlternate = (ResourceAlternate)resultRow[0];
            ResourceSublocation resourceSublocation = (ResourceSublocation)resultRow[1];
            return new ResourcesResponse(resourceAlternate.getId(), resourceAlternate.getAlternateResource().getId(), resourceAlternate.getAlternateResource().getName(), resourceAlternate.getAlternateResource().getResourceType().getName(), resourceSublocation.getSublocation().getId(), resourceSublocation.getSublocation().getName(), resourceSublocation.isActive(), total);
        };
        return ListUtils.enrich((List)resultSet).map(toResponse).toList();
    }

    public List<Resource> getResourcesAvailableForGenderBlockRestriction(int resourceId) {
        String findResource = "SELECT r FROM Resource r WHERE r.id != :resourceId and (r.sharedResource = null or r.sharedResource = :resourceId) and r.resourceType = 'Room' and (SELECT COUNT(*) FROM ResourceSublocation rs WHERE rs.resource.id = r.id and rs.active = 1) > 0 order by r.name ASC";
        Query query = this.newQuery("SELECT r FROM Resource r WHERE r.id != :resourceId and (r.sharedResource = null or r.sharedResource = :resourceId) and r.resourceType = 'Room' and (SELECT COUNT(*) FROM ResourceSublocation rs WHERE rs.resource.id = r.id and rs.active = 1) > 0 order by r.name ASC").setParameter("resourceId", (Object)resourceId);
        List resultSet = query.list();
        return resultSet;
    }

    public List<SublocationClosureIntervalResponse> getSublocationClosureInterval(String sortBy, String orderBy, int page, int maxResults) {
        String findSublocationIntervals = "SELECT sci FROM SublocationClosureInterval sci  order by " + sortBy + " " + orderBy;
        Query query = this.newQuery(findSublocationIntervals);
        Long total = query.list().size();
        int offset = (page - 1) * maxResults;
        query.setFirstResult(offset);
        query.setMaxResults(maxResults);
        List resultSet = query.list();
        Function<SublocationClosureInterval, SublocationClosureIntervalResponse> toResponse = resultRow -> new SublocationClosureIntervalResponse(resultRow.getId(), resultRow.getStartTime(), resultRow.getEndTime(), resultRow.getReason(), resultRow.getSublocation().getName(), total);
        return ListUtils.enrich((List)resultSet).map(toResponse).toList();
    }

    public List<ResourcesResponse> findResourcesWithSublocationAndAlternates(Resource resource, List<Resource> altResource, String sortBy, String orderBy, int page, int maxResults) {
        String ignoreCurrentAlts = altResource.isEmpty() ? "" : " and rs.resource NOT IN (:altResource) ";
        String findResource = "SELECT r FROM Resource r, ResourceSublocation rs  WHERE rs.resource = r.id and rs.resource != :resource " + ignoreCurrentAlts + " order by " + sortBy + " " + orderBy;
        Query query = this.newQuery(findResource).setParameter("resource", (Object)resource);
        if (!ignoreCurrentAlts.isEmpty()) {
            query.setParameterList("altResource", altResource);
        }
        Long total = query.list().size();
        int offset = (page - 1) * maxResults;
        query.setFirstResult(offset);
        query.setMaxResults(maxResults);
        List resourceList = query.list();
        Function<Resource, ResourcesResponse> toResourcesResponse = r -> {
            ResourceSublocation resourceSublocation = this.findSublocationByResource((Resource)r);
            return new ResourcesResponse(r.getId(), r.getId(), r.getName(), r.getResourceType().getName(), resourceSublocation.getSublocation().getId(), resourceSublocation.getSublocation().getName(), resourceSublocation.isActive(), (long)total);
        };
        return ListUtils.enrich((List)resourceList).map(toResourcesResponse).toList();
    }

    public ResourceSublocation findSublocationByResource(Resource r) {
        Criteria crit = this.newCriteria(ResourceSublocation.class).add((Criterion)Restrictions.eq((String)"resource", (Object)r));
        return (ResourceSublocation)crit.uniqueResult();
    }

    public ResourceSublocation findResourceSublocation(Integer resourceId, Integer sublocationId) {
        String findResourceSublocation = "SELECT rs FROM ResourceSublocation rs    where rs.resource.id=:resourceId and rs.sublocation.id=:sublocationId";
        Query query = this.newQuery("SELECT rs FROM ResourceSublocation rs    where rs.resource.id=:resourceId and rs.sublocation.id=:sublocationId");
        query.setParameter("resourceId", (Object)resourceId);
        query.setParameter("sublocationId", (Object)sublocationId);
        ResourceSublocation resourceSublocation = (ResourceSublocation)query.uniqueResult();
        return resourceSublocation;
    }

    public ResourceSublocation findUniqueResourceSublocationByResource(Resource resource) {
        String findResourceSublocation = "SELECT rs FROM ResourceSublocation rs where rs.resource = :resource";
        Query query = this.newQuery("SELECT rs FROM ResourceSublocation rs where rs.resource = :resource");
        query.setParameter("resource", (Object)resource);
        ResourceSublocation resourceSublocation = (ResourceSublocation)query.uniqueResult();
        return resourceSublocation;
    }
}

