/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.persistence;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.hccrc.core.util.ListUtils;
import edu.harvard.catalyst.hccrc.core.util.RichIterator;
import edu.harvard.catalyst.hccrc.core.util.RichList;
import edu.harvard.catalyst.hccrc.core.util.Try;
import edu.harvard.catalyst.scheduler.dto.response.ReportTemplateMetadataDTO;
import edu.harvard.catalyst.scheduler.dto.response.ReportTemplateResultDTO;
import edu.harvard.catalyst.scheduler.entity.SubjectMrn;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.entity.VisitType;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.Category;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.Field;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.FieldProcessingEnum;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.Graph;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.ReportTemplate;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.SubCategory;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.TemplateCategory;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.TemplateCategoryField;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.TemplateUser;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.TemplateUserFilterSelection;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.TemplateUserSelection;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.TemplateUserSortSelection;
import edu.harvard.catalyst.scheduler.persistence.SiteDAO;
import edu.harvard.catalyst.scheduler.util.DateUtility;
import edu.harvard.catalyst.scheduler.util.SubjectDataEncryptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository
public class ReportTemplateDAO
extends SiteDAO {
    private static final Logger LOGGER = Logger.getLogger(ReportTemplateDAO.class);
    private static final Function<Object, Date> toDate = o -> (Date)o;
    private static final Function<Date, Date> toEndOfDay = ReportTemplateDAO.passNullsThrough(DateUtility::adjustToEndOfDay);
    private static final Function<Date, Integer> toMinutes = ReportTemplateDAO.passNullsThrough(date -> DateUtility.convertMillisToMinutes(date.getTime()));
    public static final Comparator<Object> comparatorAsc = (o1, o2) -> o1.toString().compareToIgnoreCase(o2.toString());

    public ReportTemplate findTemplateById(Integer id) {
        return this.findById(ReportTemplate.class, id);
    }

    public TemplateUser findTemplateUserById(Integer id) {
        return this.findById(TemplateUser.class, id);
    }

    public List<TemplateCategory> findCategoriesByTemplate(ReportTemplate reportTemplate) {
        Criteria crit = this.newCriteria(TemplateCategory.class).add((Criterion)Restrictions.eq((String)"reportTemplate", (Object)reportTemplate));
        return crit.list();
    }

    public List<SubCategory> findSubCategoriesByCategoryAndTemplate(Category category, ReportTemplate reportTemplate) {
        Criteria crit = this.newCriteria(SubCategory.class);
        crit.add((Criterion)Restrictions.eq((String)"parent", (Object)category));
        crit.add((Criterion)Restrictions.eq((String)"reportTemplate", (Object)reportTemplate));
        return crit.list();
    }

    public List<TemplateCategoryField> findTcfsByCategoryAndTemplate(Category category, ReportTemplate reportTemplate) {
        Criteria crit = this.newCriteria(TemplateCategoryField.class);
        crit.add((Criterion)Restrictions.eq((String)"category", (Object)category));
        crit.add((Criterion)Restrictions.eq((String)"reportTemplate", (Object)reportTemplate));
        return crit.list();
    }

    public ReportTemplateResultDTO runQueryAndScalars(String reportName, Graph.QueryScalarsTcfs queryScalarsTcfs, Date from, Date to, int offset, int limit) {
        return this.runQueryAndScalars(reportName, queryScalarsTcfs, from, to, offset, limit, false);
    }

    public ReportTemplateResultDTO runQueryAndScalars(String reportName, Graph.QueryScalarsTcfs queryScalarsTcfs, Date from, Date to, int offset, int limit, boolean countOnly) {
        List listOfResultSetObjects;
        ReportTemplateResultDTO reportTemplateResultDTO = new ReportTemplateResultDTO(reportName);
        List<TemplateCategoryField> qsfTcfs = queryScalarsTcfs.getTcfs();
        if (offset == 0) {
            List headerList = ListUtils.enrich(qsfTcfs).map(tcf -> {
                Field field = tcf.getField();
                Category category = tcf.getCategory();
                return category.getCsvName() + " - " + field.getDisplayName();
            }).toList();
            reportTemplateResultDTO.setCsvHeaders(headerList);
        }
        List<String> qsfScalars = queryScalarsTcfs.getScalars();
        String queryString = this.makeQueryString(queryScalarsTcfs, from, to, offset, limit, countOnly);
        SQLQuery sqlQuery = this.newSqlQuery(queryString);
        this.addToAndFrom(to, from, sqlQuery);
        if (!countOnly) {
            qsfScalars.forEach(arg_0 -> ((SQLQuery)sqlQuery).addScalar(arg_0));
            if (offset == 0) {
                reportTemplateResultDTO.setCachedQsTcfs(queryScalarsTcfs);
                LOGGER.info((Object)("\n--> Running query: " + queryString));
            }
        }
        if ((listOfResultSetObjects = sqlQuery.list()).isEmpty()) {
            return reportTemplateResultDTO;
        }
        Object firstResultSet = listOfResultSetObjects.get(0);
        boolean oneObject = !(firstResultSet instanceof Object[]);
        Function<Object, List> toCsvRow = resultSetObject -> {
            Object[] objectArray;
            if (oneObject) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = resultSetObject;
            } else {
                objectArray = (Object[])resultSetObject;
            }
            Object[] resultSetAsArray = objectArray;
            RichIterator fields = ReportTemplateDAO.richIterator(ListUtils.enrich((List)qsfTcfs).map(tcf -> tcf.getField()));
            RichIterator remaining = ReportTemplateDAO.richIterator(ListUtils.enrich((Object[])resultSetAsArray));
            RichIterator csvFields = fields.map(this.toCsvField(remaining));
            return csvFields.toList();
        };
        List csvRows = ListUtils.enrich((List)listOfResultSetObjects).map(toCsvRow).toList();
        reportTemplateResultDTO.setCsvRows(csvRows);
        return reportTemplateResultDTO;
    }

    private static final <A> RichIterator<A> richIterator(RichList<A> rl) {
        return RichIterator.enrich((Iterator)rl.iterator());
    }

    Function<Field, String> toCsvField(RichIterator<Object> remaining) {
        return field -> {
            FieldProcessingEnum fieldProcessingEnum = field.getFieldProcessingEnum();
            String columnsString = field.getColumn();
            ArrayList columns = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)columnsString));
            int numColumns = columns.size();
            Object rsField = numColumns == 1 ? this.handleOneColumn(remaining.next(), fieldProcessingEnum) : (numColumns == 2 ? this.handleTwoColumns(remaining, fieldProcessingEnum) : (numColumns == 4 ? this.handleFourColumns(remaining) : "<bad case>"));
            return ReportTemplateDAO.stringOrDateAsString(rsField);
        };
    }

    Integer handleFourColumns(RichIterator<Object> remaining) {
        List timestamps = remaining.take(4).map(toDate).map(ReportTemplateDAO.passNullsThrough(Date::getTime)).toList();
        if (timestamps.contains(null)) {
            return null;
        }
        Long difference1 = (Long)timestamps.get(0) - (Long)timestamps.get(1);
        Long difference2 = (Long)timestamps.get(2) - (Long)timestamps.get(3);
        return DateUtility.convertMillisecondsToMinutes(difference1 - difference2);
    }

    Integer handleTwoColumns(RichIterator<Object> remaining, FieldProcessingEnum fieldProcessingEnum) {
        RichList dates = remaining.take(2).map(toDate).toRichList();
        if (dates.contains(null)) {
            return null;
        }
        if (fieldProcessingEnum == FieldProcessingEnum.actualDurationOvernights) {
            RichList adjustedDates = dates.map(toEndOfDay);
            return DateUtility.day2minusDay1((Date)adjustedDates.get(1), (Date)adjustedDates.get(0));
        }
        RichList minutes = dates.map(toMinutes);
        int elapsed = (Integer)minutes.get(0) - (Integer)minutes.get(1);
        return elapsed;
    }

    Object handleOneColumn(Object o, FieldProcessingEnum fieldProcessingEnum) {
        if (fieldProcessingEnum == FieldProcessingEnum.decrypt) {
            return this.wrappedDecryptor((String)o);
        }
        if (fieldProcessingEnum == FieldProcessingEnum.earliestBookedVisit) {
            return this.findExtremeVisitByStudyId((Integer)o, "min");
        }
        if (fieldProcessingEnum == FieldProcessingEnum.latestBookedVisit) {
            return this.findExtremeVisitByStudyId((Integer)o, "max");
        }
        if (fieldProcessingEnum == FieldProcessingEnum.SublocationFromTr) {
            return this.findSublocationByByTemplateResourceId((Integer)o);
        }
        if (fieldProcessingEnum == FieldProcessingEnum.ResourceFromTr) {
            return this.findNameById("Resource", (Integer)o);
        }
        if (fieldProcessingEnum == FieldProcessingEnum.InstitutionFromStudy) {
            return this.findNameById("Institution", (Integer)o);
        }
        if (fieldProcessingEnum == FieldProcessingEnum.MrnFromSubjectMrn) {
            SubjectMrn subjectMrn = this.findById(SubjectMrn.class, (Integer)o);
            if (subjectMrn != null) {
                String decryptedMrn = this.wrappedDecryptor(subjectMrn.getMrn());
                String site = subjectMrn.getSite() == null ? "" : " " + subjectMrn.getSite();
                return decryptedMrn + site;
            }
            return "null";
        }
        if (fieldProcessingEnum == FieldProcessingEnum.Resource) {
            return o;
        }
        if (fieldProcessingEnum == FieldProcessingEnum.DefaultPlusAnnotations) {
            return o;
        }
        if (fieldProcessingEnum == FieldProcessingEnum.VisitType) {
            if (o == null) {
                return null;
            }
            VisitType visitType = VisitType.valueOf((String)o);
            return visitType.getName();
        }
        if (fieldProcessingEnum != FieldProcessingEnum.DEFAULT) {
            String result = null == o ? "" : this.findNameById(fieldProcessingEnum.toString(), (Integer)o);
            return result;
        }
        return o;
    }

    String wrappedDecryptor(String input) {
        return SubjectDataEncryptor.decrypt(input);
    }

    private static <A, B> Function<A, B> passNullsThrough(Function<? super A, ? extends B> f) {
        return a -> a == null ? null : f.apply((Object)a);
    }

    private void addToAndFrom(Date to, Date from, SQLQuery sqlQuery) {
        if (from != null && to != null) {
            sqlQuery.setParameter("startTime", (Object)from);
            sqlQuery.setParameter("endTime", (Object)to);
        }
    }

    private String makeQueryString(Graph.QueryScalarsTcfs queryScalarsTcfs, Date from, Date to, int offset, int limit, boolean countOnly) {
        String qsfQuery = queryScalarsTcfs.getQueryString();
        String countPrefix = countOnly ? "select count(*) from ( " : "";
        String countSuffix = countOnly ? ") temp2 " : "";
        String limits = countOnly ? "" : " limit " + limit + " offset " + offset;
        String orderQuery = queryScalarsTcfs.getOrderString();
        StringBuilder queryWrapper = new StringBuilder();
        queryWrapper.append(countPrefix);
        queryWrapper.append(qsfQuery);
        ArrayList lastMinuteWhereClauseList = Lists.newArrayList();
        if (from != null && to != null) {
            lastMinuteWhereClauseList.add("((:startTime between bv.scheduled_start_time and bv.scheduled_end_time)  or (:endTime between bv.scheduled_start_time and bv.scheduled_end_time) or  (bv.scheduled_start_time >= :startTime and bv.scheduled_end_time <= :endTime)) ");
        }
        if (!lastMinuteWhereClauseList.isEmpty()) {
            String andOrWhere = qsfQuery.toLowerCase().contains(" where ") ? " AND " : " WHERE ";
            queryWrapper.append(andOrWhere);
            String lastMinuteWhereClausesString = Joiner.on((String)" AND ").join((Iterable)lastMinuteWhereClauseList);
            queryWrapper.append(lastMinuteWhereClausesString);
        }
        queryWrapper.append(orderQuery);
        queryWrapper.append(limits);
        queryWrapper.append(countSuffix);
        return queryWrapper.toString();
    }

    public List<ReportTemplateMetadataDTO> findTemplateListByTypeAndUser(User user) {
        String query = "select t.id, t.display_name, t.type from report_template t ";
        SQLQuery sqlQuery = this.newSqlQuery("select t.id, t.display_name, t.type from report_template t ");
        List listOfResultSetObjects = sqlQuery.list();
        List finalList = ListUtils.enrich((List)listOfResultSetObjects).map(obj -> {
            Integer id = (Integer)obj[0];
            String name = (String)obj[1];
            String type = (String)obj[2];
            return new ReportTemplateMetadataDTO(id, id, name, type, name, null);
        }).toList();
        finalList.addAll(this.findUsersReportListByTypeAndUser(user, null));
        return finalList;
    }

    public List<ReportTemplateMetadataDTO> findUsersReportListByTypeAndUser(User user, Integer selectedTemplate) {
        String excludeClause = " ";
        if (selectedTemplate != null) {
            excludeClause = " and tu.id != " + selectedTemplate;
        }
        String query = "select tu.id, tu.report_template_id, tu.name, t.type, t.display_name, tu.last_update_time FROM report_template t, template_user tu WHERE tu.report_template_id = t.id " + excludeClause + " and tu.user_id=" + user.getId() + " ORDER BY tu.name ";
        SQLQuery sqlQuery = this.newSqlQuery(query);
        List listOfResultSetObjects = sqlQuery.list();
        return ListUtils.enrich((List)listOfResultSetObjects).map(obj -> {
            Integer id = (Integer)obj[0];
            Integer reportTemplateId = (Integer)obj[1];
            String name = (String)obj[2];
            String type = (String)obj[3];
            String baseReport = (String)obj[4];
            Date latestUpdate = (Date)obj[5];
            return new ReportTemplateMetadataDTO(id, reportTemplateId, name, type, baseReport, latestUpdate);
        }).toList();
    }

    public List<TemplateCategoryField> findTcfsById(List<Integer> tcfIds) {
        if (tcfIds.isEmpty()) {
            return new ArrayList<TemplateCategoryField>();
        }
        String inListString = Joiner.on((String)",").join(tcfIds);
        String query = "select tcf from TemplateCategoryField tcf where tcf.id in (" + inListString + ") order by tcf.csvOrder2, tcf.csvOrder";
        return this.newQuery(query).list();
    }

    public List<TemplateUserSelection> findTemplateUserSelectionsById(Integer templateUserId) {
        String query = "select tus from TemplateUserSelection tus where tus.templateUser.id in (" + templateUserId + ") ";
        return this.newQuery(query).list();
    }

    public List<TemplateUserSortSelection> findTemplateUserSortSelectionsByTemplateUserSelection(List<Integer> templateUserSelectionId) {
        if (templateUserSelectionId.isEmpty()) {
            return new ArrayList<TemplateUserSortSelection>();
        }
        String inListString = Joiner.on((String)",").join(templateUserSelectionId);
        String query = "select tuss from TemplateUserSortSelection tuss where tuss.templateUserSelection.id in (" + inListString + ") ";
        return this.newQuery(query).list();
    }

    public List<TemplateUserFilterSelection> findTemplateUserFilterSelectionsByTemplateUserSelection(List<Integer> templateUserSelectionId) {
        if (templateUserSelectionId.isEmpty()) {
            return new ArrayList<TemplateUserFilterSelection>();
        }
        String inListString = Joiner.on((String)",").join(templateUserSelectionId);
        String query = "select tufs from TemplateUserFilterSelection tufs where tufs.templateUserSelection.id in (" + inListString + ") ";
        return this.newQuery(query).list();
    }

    Date findExtremeVisitByStudyId(Integer study, String minOrMax) {
        String queryString = " select " + minOrMax + "(bv.scheduled_start_time) min from booked_visit bv where bv.study =:study";
        SQLQuery query = this.newSqlQuery(queryString);
        query.setParameter("study", (Object)study);
        query.addScalar("min");
        Date date = (Date)query.uniqueResult();
        return date;
    }

    String findSublocationByByTemplateResourceId(Integer templateResourceId) {
        if (templateResourceId == null) {
            return null;
        }
        String queryString = "select s.name name from sublocation s, resource r, template_resource tr, resource_sublocation rs where tr.resource = r.id and rs.resource = r.id and rs.sublocation = s.id and tr.id =:templateResourceId";
        SQLQuery query = this.newSqlQuery("select s.name name from sublocation s, resource r, template_resource tr, resource_sublocation rs where tr.resource = r.id and rs.resource = r.id and rs.sublocation = s.id and tr.id =:templateResourceId");
        query.setParameter("templateResourceId", (Object)templateResourceId);
        query.addScalar("name");
        String name = (String)query.uniqueResult();
        return name;
    }

    public static String stringOrDateAsString(Object object) {
        if (object == null || object.toString().matches("^\\s*$")) {
            return "null";
        }
        if (object instanceof Date) {
            return ReportTemplateDAO.dateToCsvFormat((Date)object);
        }
        return ReportTemplateDAO.otherToCsvFormat(object);
    }

    private static String otherToCsvFormat(Object object) {
        String result = object.toString();
        if (ReportTemplateDAO.isLong(result)) {
            return "\"=\"\"" + result + "\"\"\"";
        }
        return StringEscapeUtils.escapeCsv((String)result);
    }

    private static String dateToCsvFormat(Date date) {
        String result = DateUtility.format(DateUtility.dateHourMin(), date);
        return StringEscapeUtils.escapeCsv((String)result);
    }

    private static final boolean isLong(String stringRep) {
        return Try.attempt(() -> Long.parseLong(stringRep)).isSuccess();
    }

    public boolean checkSavedReportName(String reportName, Integer reportId, boolean isNewReport, Integer userId) {
        SQLQuery sqlQuery;
        List listOfResultSetObjects;
        String sql = "select tu.name from template_user tu WHERE tu.name=\"" + reportName + "\" and tu.user_id = " + userId;
        if (!isNewReport) {
            sql = sql + " and tu.id != " + reportId;
        }
        return (listOfResultSetObjects = (sqlQuery = this.newSqlQuery(sql)).list()).size() != 0;
    }

    public List<Object> findListByClass(String tableName, String columnName) {
        String findName = "SELECT table FROM " + tableName + " table ORDER BY table." + columnName;
        Query query = this.newQuery(findName);
        List result = query.list();
        return result;
    }

    public List<Object> findListByColumn(String tableName, String columnName, String filterBy, String selectedTerms) {
        String findName = "SELECT DISTINCT a." + columnName + " FROM " + tableName + " a WHERE a." + columnName + " LIKE ('%" + filterBy + "%') ";
        if (!selectedTerms.isEmpty()) {
            findName = findName + " AND a." + columnName + " NOT IN (" + selectedTerms + ")";
        }
        findName = findName + " ORDER BY a." + columnName;
        SQLQuery query = this.newSqlQuery(findName);
        List result = query.list();
        String nullString = "Null".toLowerCase();
        if (nullString.contains(filterBy.toLowerCase())) {
            result.add("Null");
        }
        Collections.sort(result, comparatorAsc);
        return result;
    }
}

