/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto.response;

import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.entity.VisitTemplate;
import java.util.Date;

public final class VisitTemplateDetailResponse {
    private final Integer id;
    private final String visitName;
    private final String studyName;
    private final String shortName;
    private final String sublocationName;
    private final int sublocationId;
    private final String visitTypeName;
    private final int visitTypeId;
    private final String comment;
    private final boolean researchPharmacy;
    private final boolean institutionNonCrc;
    private final boolean nonInstitutionNonCrc;
    private final String nursing;
    private final String nutrition;
    private final String processing;
    private final String setup;
    private final boolean relativeTime;
    private final String approved;
    private final Date createdDate;
    private long numVisitTemplateComments;

    public VisitTemplateDetailResponse(VisitTemplate visit) {
        if (visit == null) {
            SchedulerRuntimeException.logAndThrow("Visit parameter should be non-null");
        }
        this.id = visit.getId();
        this.visitName = visit.getName();
        this.studyName = visit.getStudy().getName();
        this.shortName = visit.getShortName();
        this.sublocationName = visit.getSublocation().getName();
        this.sublocationId = visit.getSublocation().getId();
        this.visitTypeName = visit.getVisitType().getName();
        this.visitTypeId = visit.getVisitType().getId();
        this.comment = visit.getComment();
        this.researchPharmacy = visit.getResearchPharmacy();
        this.institutionNonCrc = visit.getInstitutionNonCRC();
        this.nonInstitutionNonCrc = visit.getNonInstitutionNonCRC();
        this.createdDate = visit.getCreatedDate();
        this.nursing = visit.getNursing().isEmpty() || visit.getNursing() == null ? "N/A" : visit.getNursing();
        this.nutrition = visit.getNutrition().isEmpty() || visit.getNutrition() == null ? "N/A" : visit.getNutrition();
        this.processing = visit.getProcessing().isEmpty() || visit.getProcessing() == null ? "N/A" : visit.getProcessing();
        this.setup = visit.getSetup().isEmpty() || visit.getSetup() == null ? "N/A" : visit.getSetup();
        this.relativeTime = visit.getRelativeTime();
        this.approved = visit.getApproved() != false ? "Approved" : "Not Approved";
    }

    public void setNumVisitTemplateComments(long numVisitTemplateComments) {
        this.numVisitTemplateComments = numVisitTemplateComments;
    }

    public Long getNumVisitTemplateComments() {
        return this.numVisitTemplateComments;
    }
}

