/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.util.Assert;

public class DirtiesContextTestExecutionListener
extends AbstractTestExecutionListener {
    private static final Log logger = LogFactory.getLog(DirtiesContextTestExecutionListener.class);

    @Deprecated
    protected void dirtyContext(TestContext testContext) {
        testContext.markApplicationContextDirty();
        testContext.setAttribute(DependencyInjectionTestExecutionListener.REINJECT_DEPENDENCIES_ATTRIBUTE, Boolean.TRUE);
    }

    protected void dirtyContext(TestContext testContext, DirtiesContext.HierarchyMode hierarchyMode) {
        testContext.markApplicationContextDirty(hierarchyMode);
        testContext.setAttribute(DependencyInjectionTestExecutionListener.REINJECT_DEPENDENCIES_ATTRIBUTE, Boolean.TRUE);
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
        DirtiesContext.ClassMode classMode;
        Class<?> testClass = testContext.getTestClass();
        Assert.notNull(testClass, (String)"The test class of the supplied TestContext must not be null");
        Method testMethod = testContext.getTestMethod();
        Assert.notNull((Object)testMethod, (String)"The test method of the supplied TestContext must not be null");
        Class<DirtiesContext> annotationType = DirtiesContext.class;
        boolean methodDirtiesContext = testMethod.isAnnotationPresent(annotationType);
        boolean classDirtiesContext = testClass.isAnnotationPresent(annotationType);
        DirtiesContext classDirtiesContextAnnotation = testClass.getAnnotation(annotationType);
        DirtiesContext.ClassMode classMode2 = classMode = classDirtiesContext ? classDirtiesContextAnnotation.classMode() : null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("After test method: context [" + (Object)((Object)testContext) + "], class dirties context [" + classDirtiesContext + "], class mode [" + (Object)((Object)classMode) + "], method dirties context [" + methodDirtiesContext + "]."));
        }
        if (methodDirtiesContext || classDirtiesContext && classMode == DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD) {
            DirtiesContext.HierarchyMode hierarchyMode = methodDirtiesContext ? testMethod.getAnnotation(annotationType).hierarchyMode() : classDirtiesContextAnnotation.hierarchyMode();
            this.dirtyContext(testContext, hierarchyMode);
        }
    }

    public void afterTestClass(TestContext testContext) throws Exception {
        Class<?> testClass = testContext.getTestClass();
        Assert.notNull(testClass, (String)"The test class of the supplied TestContext must not be null");
        Class<DirtiesContext> annotationType = DirtiesContext.class;
        boolean dirtiesContext = testClass.isAnnotationPresent(annotationType);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("After test class: context [" + (Object)((Object)testContext) + "], dirtiesContext [" + dirtiesContext + "]."));
        }
        if (dirtiesContext) {
            DirtiesContext.HierarchyMode hierarchyMode = testClass.getAnnotation(annotationType).hierarchyMode();
            this.dirtyContext(testContext, hierarchyMode);
        }
    }
}

