/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateAccessor;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class HibernateInterceptor
extends HibernateAccessor
implements MethodInterceptor {
    private boolean exceptionConversionEnabled = true;

    public void setExceptionConversionEnabled(boolean exceptionConversionEnabled) {
        this.exceptionConversionEnabled = exceptionConversionEnabled;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Object object;
        block12: {
            SessionHolder sessionHolder;
            Session session;
            block11: {
                boolean existingTransaction;
                session = this.getSession();
                sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.getSessionFactory()));
                boolean bl = existingTransaction = sessionHolder != null && sessionHolder.containsSession(session);
                if (existingTransaction) {
                    this.logger.debug((Object)"Found thread-bound Session for HibernateInterceptor");
                } else if (sessionHolder != null) {
                    sessionHolder.addSession(session);
                } else {
                    TransactionSynchronizationManager.bindResource((Object)this.getSessionFactory(), (Object)((Object)new SessionHolder(session)));
                }
                FlushMode previousFlushMode = null;
                try {
                    previousFlushMode = this.applyFlushMode(session, existingTransaction);
                    this.enableFilters(session);
                    Object retVal = methodInvocation.proceed();
                    this.flushIfNecessary(session, existingTransaction);
                    object = retVal;
                    Object var9_9 = null;
                    if (!existingTransaction) break block11;
                }
                catch (HibernateException ex) {
                    try {
                        if (this.exceptionConversionEnabled) {
                            throw this.convertHibernateAccessException(ex);
                        }
                        throw ex;
                    }
                    catch (Throwable throwable) {
                        block14: {
                            block13: {
                                Object var9_10 = null;
                                if (!existingTransaction) break block13;
                                this.logger.debug((Object)"Not closing pre-bound Hibernate Session after HibernateInterceptor");
                                this.disableFilters(session);
                                if (previousFlushMode == null) break block14;
                                session.setFlushMode(previousFlushMode);
                                break block14;
                            }
                            SessionFactoryUtils.closeSessionOrRegisterDeferredClose(session, this.getSessionFactory());
                            if (sessionHolder != null && !sessionHolder.doesNotHoldNonDefaultSession()) break block14;
                            TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory());
                        }
                        throw throwable;
                    }
                }
                this.logger.debug((Object)"Not closing pre-bound Hibernate Session after HibernateInterceptor");
                this.disableFilters(session);
                if (previousFlushMode != null) {
                    session.setFlushMode(previousFlushMode);
                }
                break block12;
            }
            SessionFactoryUtils.closeSessionOrRegisterDeferredClose(session, this.getSessionFactory());
            if (sessionHolder == null || sessionHolder.doesNotHoldNonDefaultSession()) {
                TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory());
            }
        }
        return object;
    }

    protected Session getSession() {
        return SessionFactoryUtils.getSession(this.getSessionFactory(), this.getEntityInterceptor(), this.getJdbcExceptionTranslator());
    }
}

