/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.persistence;

import com.google.common.collect.Maps;
import com.google.common.io.CharStreams;
import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.dto.Epic.EmpiSubjectDto;
import edu.harvard.catalyst.scheduler.dto.ExternalSubjectQueryBuilder;
import edu.harvard.catalyst.scheduler.dto.response.MrnInfoDTO;
import edu.harvard.catalyst.scheduler.dto.response.SubjectDetailResponse;
import edu.harvard.catalyst.scheduler.dto.response.SubjectsResponseDTO;
import edu.harvard.catalyst.scheduler.entity.Ethnicity;
import edu.harvard.catalyst.scheduler.entity.Gender;
import edu.harvard.catalyst.scheduler.entity.GenderType;
import edu.harvard.catalyst.scheduler.persistence.SubjectDAO;
import edu.harvard.catalyst.scheduler.service.EpicSubjectService;
import edu.harvard.catalyst.scheduler.util.PropertyHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
public class EpicSubjectDAO
extends SubjectDAO {
    public static String BLANK = "";
    private static volatile Map<String, Ethnicity> empiSchedulerEthnicityMap;
    private static int UNKNOWN_OR_NOT_REPORTED_ETHNICITY;
    static final int MAX_TIMEOUT_TRIES = 3;
    static final int MAX_TIMEOUT_FAILURES = 3;
    static int nightlyBatchSuccessiveFailures;
    private final String puidSite;

    @Autowired(required=false)
    public EpicSubjectDAO(@Qualifier(value="puidSite") String puidSite) {
        this.puidSite = puidSite;
    }

    public EpicSubjectDAO() {
        this(null);
    }

    int getNightlyBatchSuccessiveFailures() {
        return nightlyBatchSuccessiveFailures;
    }

    static void incrementNightlyBatchSuccessiveTimeoutFailures() {
        ++nightlyBatchSuccessiveFailures;
    }

    static void resetNightlyBatchSuccessiveTimeoutFailures() {
        nightlyBatchSuccessiveFailures = 0;
    }

    String emptyToQuotedEmpty(String input) {
        String result = input;
        if (result != null && result.isEmpty()) {
            result = "\"\"";
        }
        return result;
    }

    public EmpiSubjectDto getSearchedSubjectsAsEmpiSubjectDto(ExternalSubjectQueryBuilder externalSubjectQueryBuilder, boolean tolerateTimeouts) {
        String queryPayload = externalSubjectQueryBuilder.puidSite(this.puidSite).build();
        return this.httpClientQuery(queryPayload, tolerateTimeouts, 3, 3);
    }

    public SubjectsResponseDTO getSearchedSubjects(String subjectLastName, String subjectFirstName, String subjectMrn, String subjectBirthDate, String subjectGenderCode) {
        ExternalSubjectQueryBuilder externalSubjectQueryBuilder = new ExternalSubjectQueryBuilder().lastName(subjectLastName).firstName(subjectFirstName).mrn(subjectMrn).birthdate(subjectBirthDate).genderCode(subjectGenderCode);
        EmpiSubjectDto empiSubjectDto = this.getSearchedSubjectsAsEmpiSubjectDto(externalSubjectQueryBuilder, false);
        if (empiSubjectDto.getPatients() != null) {
            for (EmpiSubjectDto.Patient patient : empiSubjectDto.getPatients().getPatientList()) {
                Gender gender = this.findGenderByCode(Gender.class, patient.getGender());
                if (gender == null) {
                    gender = this.findGenderByCode(Gender.class, GenderType.UNREPORTED.getGenderName());
                }
                patient.setGender(gender.getName());
            }
        }
        SubjectsResponseDTO result = SubjectsResponseDTO.createSubjectsResponseDTO(empiSubjectDto);
        return result;
    }

    int getResponseCode(HttpURLConnection conn) throws IOException {
        return conn.getResponseCode();
    }

    OutputStream getOutputStream(HttpURLConnection conn) throws IOException {
        return conn.getOutputStream();
    }

    String getResultXml(HttpURLConnection conn) throws IOException {
        InputStream inputStream = conn.getInputStream();
        String resultXml = CharStreams.toString((Readable)new InputStreamReader(inputStream, "UTF-8"));
        return resultXml;
    }

    EmpiSubjectDto httpClientQuery(String queryPayload, boolean tolerateSomeTimeouts, int triesPerTimeout, int timeoutsPerFail) {
        return this.httpClientQuery(queryPayload, 0, tolerateSomeTimeouts, triesPerTimeout, timeoutsPerFail);
    }

    EmpiSubjectDto httpClientQuery(String queryPayload, int timeoutTryNumber, boolean tolerateSomeTimeouts, int triesPerTimeout, int timeoutsPerFail) {
        String resultXml = null;
        String logMessage = null;
        EmpiSubjectDto empiSubjectDto = new EmpiSubjectDto();
        Properties schedulerProps = PropertyHelper.getProperties("scheduler.properties", this.getClass());
        String partnersUrlHost = schedulerProps.getProperty("pUrlHost");
        String partnersUrlQuery = schedulerProps.getProperty("pUrlQuery");
        String partnersHttp = schedulerProps.getProperty("pHttp");
        String fullUrl = partnersHttp + "://" + partnersUrlHost + partnersUrlQuery;
        try {
            URL url = new URL(fullUrl);
            final String basicUser = schedulerProps.getProperty("basicUser");
            final String basicPassword = schedulerProps.getProperty("basicPassword");
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(basicUser, basicPassword.toCharArray());
                }
            });
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", "application/xml");
            OutputStream os = this.getOutputStream(conn);
            os.write(queryPayload.getBytes());
            os.flush();
            int responseCode = this.getResponseCode(conn);
            if (responseCode == 200) {
                resultXml = this.getResultXml(conn);
                EpicSubjectDAO.resetNightlyBatchSuccessiveTimeoutFailures();
            } else if (responseCode == 503) {
                logMessage = "Empi server is unavailable: " + responseCode;
                SchedulerRuntimeException.logAndThrow(logMessage);
            } else if (responseCode == 504) {
                if (++timeoutTryNumber < triesPerTimeout) {
                    logMessage = "Service timed out. Please try again later.";
                    SchedulerRuntimeException.logAndMaybeThrow(logMessage, !tolerateSomeTimeouts);
                    return this.httpClientQuery(queryPayload, timeoutTryNumber, tolerateSomeTimeouts, triesPerTimeout, timeoutsPerFail);
                }
                EpicSubjectDAO.incrementNightlyBatchSuccessiveTimeoutFailures();
                if (this.getNightlyBatchSuccessiveFailures() == timeoutsPerFail) {
                    logMessage = "Hit the timeout-failure threshold: " + timeoutsPerFail;
                    SchedulerRuntimeException.logAndThrow(logMessage);
                } else {
                    logMessage = "Service timed out. Please try again later. No more retries of this query.";
                    SchedulerRuntimeException.logAndMaybeThrow(logMessage, !tolerateSomeTimeouts);
                }
            } else {
                logMessage = "Bad code from Empi server: " + responseCode;
                SchedulerRuntimeException.logAndThrow(logMessage);
            }
        }
        catch (IOException e) {
            logMessage = e.getMessage();
            if (logMessage == null) {
                logMessage = "SSL handshake not successful";
            }
            SchedulerRuntimeException.logAndThrow(logMessage, e);
        }
        catch (Exception e) {
            logMessage = e.getMessage();
            if (logMessage == null) {
                logMessage = "Problem executing POST request to EMPI";
            }
            if (e instanceof SchedulerRuntimeException) {
                throw e;
            }
            SchedulerRuntimeException.logAndThrow(logMessage, e);
        }
        if (resultXml != null) {
            try {
                empiSubjectDto = EmpiSubjectDto.unmarshall(resultXml);
            }
            catch (Exception e) {
                return empiSubjectDto;
            }
        }
        return empiSubjectDto;
    }

    public SubjectDetailResponse findSubjectByUid(Integer id) {
        String puid = String.valueOf(id);
        ExternalSubjectQueryBuilder externalSubjectQueryBuilder = new ExternalSubjectQueryBuilder().puid(puid);
        EmpiSubjectDto empiSubjectDto = this.getSearchedSubjectsAsEmpiSubjectDto(externalSubjectQueryBuilder, false);
        SubjectDetailResponse empiResult = this.createSubjectDetailResponse(empiSubjectDto);
        SubjectDetailResponse internalResult = this.findInternalSubjectByMrn(empiResult.getMrnInfoList());
        if (internalResult.getId() != null) {
            empiResult.setComment(internalResult.getComment());
        }
        return empiResult;
    }

    public SubjectDetailResponse createSubjectDetailResponse(EmpiSubjectDto empiSubjectDto) {
        SubjectDetailResponse result = null == empiSubjectDto || empiSubjectDto.getPatients() == null || empiSubjectDto.getPatients().getPatientList() == null || empiSubjectDto.getPatients().getPatientList().isEmpty() ? new SubjectDetailResponse() : this.setFromDto(empiSubjectDto);
        return result;
    }

    public SubjectDetailResponse setFromDto(EmpiSubjectDto empiSubjectDto) {
        Ethnicity lookedUpEthnicity;
        Gender gender;
        SubjectDetailResponse result = new SubjectDetailResponse();
        EmpiSubjectDto.Patient patient = empiSubjectDto.getPatients().getPatientList().get(0);
        result.setId(patient.getUid());
        result.setPartnersUid(String.valueOf(patient.getUid()));
        result.setLastName(patient.getName().getLast());
        result.setFirstName(patient.getName().getFirst());
        result.setMiddleName(patient.getName().getMiddleInitial());
        List<EmpiSubjectDto.Mrn> mrns = patient.getMrns().getMrnList();
        ArrayList<MrnInfoDTO> mrnInfoDTOList = new ArrayList<MrnInfoDTO>();
        for (EmpiSubjectDto.Mrn mrn : mrns) {
            MrnInfoDTO mrnInfoDTO = new MrnInfoDTO(mrn.getValue(), mrn.getSite(), mrn.getStatus());
            mrnInfoDTOList.add(mrnInfoDTO);
        }
        result.setMrnInfoList(mrnInfoDTOList);
        EmpiSubjectDto.Address address = patient.getAddress();
        if (null != address) {
            result.setCity(address.getCity());
            result.setStateName(address.getState());
            result.setCountryName(address.getCountry());
            result.setStreetAddress1(address.getLine1());
            result.setStreetAddress2(address.getLine2());
            result.setZip(address.getZipAsString());
        }
        if ((gender = this.findGenderByCode(Gender.class, patient.getGender())) == null) {
            gender = this.findGenderByCode(Gender.class, GenderType.UNREPORTED.getGenderName());
        }
        result.setGenderName(gender.getName());
        result.setGenderCode(patient.getGender());
        result.setGenderId(gender.getId());
        String ethnicName = null;
        if (null != patient.getEthnicity()) {
            ethnicName = patient.getEthnicity().getEthnic1();
        }
        result.setEthnicityName((lookedUpEthnicity = this.lookupEmpiEthnicityString(ethnicName)) != null ? lookedUpEthnicity.getName() : patient.getEthnicity() + " - N/A");
        result.setRaceName(patient.getOtherPid() != null ? patient.getOtherPid().getRace() : patient.getOtherPid() + " - N/A");
        result.setComment(BLANK);
        this.setPhoneData(result, patient);
        result.setBirthdate(new Date(patient.getDobString()));
        result.setActive(true);
        return result;
    }

    private void setPhoneData(SubjectDetailResponse result, EmpiSubjectDto.Patient patient) {
        List<EmpiSubjectDto.Phone> phoneList;
        EmpiSubjectDto.Phones phones = patient.getPhones();
        if (null != phones && null != (phoneList = phones.getPhoneList())) {
            EmpiSubjectDto.Phone secondary;
            EmpiSubjectDto.Phone primary;
            int pSize = phoneList.size();
            if (pSize >= 1 && null != (primary = phoneList.get(0))) {
                result.setPrimaryContactNumber(primary.getNumber());
            }
            if (pSize >= 2 && null != (secondary = phoneList.get(1))) {
                result.setSecondaryContactNumber(secondary.getNumber());
            }
        }
    }

    public Map<String, Ethnicity> loadEmpiToSchedulerEthnicityMap() {
        HashMap result = Maps.newHashMap();
        Query query = this.newQuery("SELECT ese FROM EthnicityMapping ese");
        List eseList = query.list();
        eseList.stream().forEach(ese -> result.put(ese.getExternalEthnicityString(), ese.getSchedulerEthnicity()));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void synchLoadEmpiSchedulerEthnicityMap() {
        if (empiSchedulerEthnicityMap != null) return;
        Class<EpicSubjectService> clazz = EpicSubjectService.class;
        synchronized (EpicSubjectService.class) {
            empiSchedulerEthnicityMap = this.loadEmpiToSchedulerEthnicityMap();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public Ethnicity lookupEmpiEthnicityString(String empiEthnicity) {
        this.synchLoadEmpiSchedulerEthnicityMap();
        Ethnicity result = empiSchedulerEthnicityMap.get(empiEthnicity);
        if (result == null) {
            result = this.findByEthnicityId(UNKNOWN_OR_NOT_REPORTED_ETHNICITY);
        }
        return result;
    }

    Map<String, Ethnicity> getEmpiSchedulerEthnicityMap() {
        return empiSchedulerEthnicityMap;
    }

    public SubjectDetailResponse getSubjectDetailsUsingMrnAndSite(String mrn, String site) {
        ExternalSubjectQueryBuilder externalSubjectQueryBuilder = new ExternalSubjectQueryBuilder().mrn(mrn).mrnSite(site);
        EmpiSubjectDto empiSubjectDto = this.getSearchedSubjectsAsEmpiSubjectDto(externalSubjectQueryBuilder, false);
        return this.createSubjectDetailResponse(empiSubjectDto);
    }

    static {
        UNKNOWN_OR_NOT_REPORTED_ETHNICITY = 3;
    }
}

