/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.util;

import com.google.common.base.Strings;
import edu.harvard.catalyst.scheduler.dto.SearchDTO;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MiscUtil {
    public static final int HASH_MODULUS = 200;

    public static boolean differentObjects(Object one, Object two) {
        boolean result = true;
        if (one == null && two == null) {
            result = false;
        } else if (one != null && one.equals(two)) {
            result = false;
        } else if (two != null && two.equals(one)) {
            result = false;
        }
        return result;
    }

    public static boolean differentStringsIgnoreCase(String one, String two) {
        if (one != null) {
            one = one.toUpperCase();
        }
        if (two != null) {
            two = two.toUpperCase();
        }
        return MiscUtil.differentObjects(one, two);
    }

    public static String throwableInfoForLog(Throwable t) {
        String result = " -- " + t.getClass().getSimpleName() + " -- " + t.getMessage();
        return result;
    }

    public static String throwableToStackTraceString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static String applyCodeToXX(String input, String code) {
        String result = input;
        if (code != null) {
            result = result.replaceAll("XX", code);
        }
        return result;
    }

    public static boolean isNonNullNonEmpty(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    public static boolean isNonNullNonEmpty(Map<?, ?> map) {
        return map != null && !map.isEmpty();
    }

    public static boolean isNonNullNonEmpty(String string) {
        return !Strings.isNullOrEmpty((String)string);
    }

    public static boolean isNullOrEmpty(List<?> list) {
        return !MiscUtil.isNonNullNonEmpty(list);
    }

    public static boolean isNullOrEmpty(String string) {
        return Strings.isNullOrEmpty((String)string);
    }

    public static StringBuilder appendIfDifferentStrings(StringBuilder builder, String oldOne, String newOne, String label) {
        builder.append(label).append(": ");
        if (MiscUtil.differentStringsIgnoreCase(oldOne, newOne)) {
            builder.append(oldOne).append(" --> ").append(newOne);
        } else {
            builder.append(oldOne).append(" (no change)");
        }
        builder.append(". ");
        return builder;
    }

    public static String undefinedToNull(String input) {
        String result = "undefined".equalsIgnoreCase(input) ? null : input;
        return result;
    }

    public static String dbFormatPhoneNumber(String input, boolean keepUnderscores, boolean includeParentheses) {
        String result = null;
        if (input != null) {
            String pattern2;
            String pattern1;
            if (keepUnderscores) {
                pattern1 = "[^\\d^_]";
                pattern2 = "([\\d_]{3})([\\d_]{3})([\\d_]{4})";
            } else {
                pattern1 = "[^\\d]";
                pattern2 = "(\\d{3})(\\d{3})(\\d{4})";
            }
            String format = includeParentheses ? "($1) $2-$3" : "$1-$2-$3";
            result = input.replaceAll(pattern1, "");
            result = result.replaceAll(pattern2, format);
        }
        return result;
    }

    public static SearchDTO.SearchItem preparePhoneNumberSearchItems(SearchDTO.SearchItem searchItem) {
        SearchDTO.SearchType searchType = searchItem.getSearchType() != null ? searchItem.getSearchType() : SearchDTO.SearchType.ANY;
        boolean keepUnderscores = searchType == SearchDTO.SearchType.ANY;
        String key = searchItem.getKey();
        String originalValue = searchItem.getValue();
        String valueWithParentheses = MiscUtil.dbFormatPhoneNumber(originalValue, keepUnderscores, true);
        String valueWithoutParentheses = MiscUtil.dbFormatPhoneNumber(originalValue, keepUnderscores, false);
        SearchDTO.SearchItem orSearchItem1 = new SearchDTO.SearchItem();
        orSearchItem1.setKey(key);
        orSearchItem1.setValue(valueWithoutParentheses);
        orSearchItem1.setSearchType(searchType);
        SearchDTO.SearchItem orSearchItem2 = new SearchDTO.SearchItem();
        orSearchItem2.setKey(key);
        orSearchItem2.setValue(valueWithParentheses);
        orSearchItem2.setSearchType(searchType);
        ArrayList<SearchDTO.SearchItem> orSearchItemList = new ArrayList<SearchDTO.SearchItem>();
        orSearchItemList.add(orSearchItem1);
        orSearchItemList.add(orSearchItem2);
        searchItem.setOrSearchItems(orSearchItemList);
        searchItem.setKey(null);
        searchItem.setValue(null);
        return searchItem;
    }

    public static final <T> Optional<T> nullToEmpty(Optional<T> o) {
        return o != null ? o : Optional.empty();
    }

    public static int moduloMinsPerHour(int totalMinutes) {
        return MiscUtil.multiDayMinutesToHourlyMinute(totalMinutes);
    }

    public static int divideByMinsPerHour(int totalMinutes) {
        return totalMinutes / 60;
    }

    public static int divideByMinsPerDay(int totalMinutes) {
        return totalMinutes / 1440;
    }

    public static int multiDayMinutesToHourlyMinute(int slotOffsetEndMinute) {
        return slotOffsetEndMinute % 60;
    }

    public static int multiDayMinutesToDailyHour(int slotOffsetStartMinute) {
        return slotOffsetStartMinute % 1440 / 60;
    }
}

